/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FontSelector {
    protected List<FontInfo> fonts;
    private static final int EXPECTED_FONT_IS_BOLD_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_BOLD_AWARD = 3;
    private static final int EXPECTED_FONT_IS_ITALIC_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_ITALIC_AWARD = 3;
    private static final int EXPECTED_FONT_IS_MONOSPACED_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_MONOSPACED_AWARD = 1;
    private static final int FONT_FAMILY_EQUALS_AWARD = 13;

    public FontSelector(Collection<FontInfo> allFonts, List<String> fontFamilies, FontCharacteristics fc) {
        this.fonts = new ArrayList<FontInfo>(allFonts);
        Collections.sort(this.fonts, this.getComparator(fontFamilies, fc));
    }

    public final FontInfo bestMatch() {
        return this.fonts.get(0);
    }

    public final Iterable<FontInfo> getFonts() {
        return this.fonts;
    }

    protected Comparator<FontInfo> getComparator(List<String> fontFamilies, FontCharacteristics fc) {
        return new PdfFontComparator(fontFamilies, fc);
    }

    private static class PdfFontComparator
    implements Comparator<FontInfo> {
        List<String> fontFamilies = new ArrayList<String>();
        List<FontCharacteristics> fontStyles = new ArrayList<FontCharacteristics>();

        PdfFontComparator(List<String> fontFamilies, FontCharacteristics fc) {
            if (fontFamilies != null && fontFamilies.size() > 0) {
                for (String fontFamily : fontFamilies) {
                    String lowercaseFontFamily = fontFamily.toLowerCase();
                    this.fontFamilies.add(lowercaseFontFamily);
                    this.fontStyles.add(PdfFontComparator.parseFontStyle(lowercaseFontFamily, fc));
                }
            } else {
                this.fontStyles.add(fc);
            }
        }

        @Override
        public int compare(FontInfo o1, FontInfo o2) {
            int res = 0;
            for (int i = 0; i < this.fontFamilies.size() && res == 0; ++i) {
                FontCharacteristics fc = this.fontStyles.get(i);
                String fontFamily = this.fontFamilies.get(i);
                if ("monospace".equalsIgnoreCase(fontFamily)) {
                    fc.setMonospaceFlag(true);
                }
                boolean isLastFontFamilyToBeProcessed = i == this.fontFamilies.size() - 1;
                res = PdfFontComparator.characteristicsSimilarity(fontFamily, fc, o2, isLastFontFamilyToBeProcessed) - PdfFontComparator.characteristicsSimilarity(fontFamily, fc, o1, isLastFontFamilyToBeProcessed);
            }
            return res;
        }

        private static FontCharacteristics parseFontStyle(String fontFamily, FontCharacteristics fc) {
            if (fc == null) {
                fc = new FontCharacteristics();
            }
            if (fc.isUndefined()) {
                if (fontFamily.contains("bold")) {
                    fc.setBoldFlag(true);
                }
                if (fontFamily.contains("italic") || fontFamily.contains("oblique")) {
                    fc.setItalicFlag(true);
                }
            }
            return fc;
        }

        private static int characteristicsSimilarity(String fontFamily, FontCharacteristics fc, FontInfo fontInfo, boolean isLastFontFamilyToBeProcessed) {
            boolean isFontBold = fontInfo.getDescriptor().isBold() || fontInfo.getDescriptor().getFontWeight() > 500;
            boolean isFontItalic = fontInfo.getDescriptor().isItalic() || fontInfo.getDescriptor().getItalicAngle() < 0.0f;
            boolean isFontMonospace = fontInfo.getDescriptor().isMonospace();
            int score = 0;
            boolean fontFamilySetByCharacteristics = false;
            if (fc.isMonospace()) {
                fontFamilySetByCharacteristics = true;
                score = isFontMonospace ? (score += 5) : (score -= 5);
            } else if (isFontMonospace) {
                --score;
            }
            if (!fontFamilySetByCharacteristics) {
                if (!"".equals(fontFamily) && (null == fontInfo.getAlias() && null != fontInfo.getDescriptor().getFamilyNameLowerCase() && fontInfo.getDescriptor().getFamilyNameLowerCase().equals(fontFamily) || null != fontInfo.getAlias() && fontInfo.getAlias().toLowerCase().equals(fontFamily))) {
                    score += 13;
                } else if (!isLastFontFamilyToBeProcessed) {
                    return score;
                }
            }
            if (fc.isBold()) {
                score = isFontBold ? (score += 5) : (score -= 5);
            } else if (isFontBold) {
                score -= 3;
            }
            if (fc.isItalic()) {
                score = isFontItalic ? (score += 5) : (score -= 5);
            } else if (isFontItalic) {
                score -= 3;
            }
            return score;
        }
    }
}

