/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSelectorKey;
import com.itextpdf.layout.font.FontSet;
import java.util.HashMap;
import java.util.Map;

class FontSelectorCache {
    private final FontSetSelectors defaultSelectors;
    private final FontSet defaultFontSet;
    private final Map<Long, FontSetSelectors> caches = new HashMap<Long, FontSetSelectors>();

    FontSelectorCache(FontSet defaultFontSet) {
        assert (defaultFontSet != null);
        this.defaultSelectors = new FontSetSelectors();
        this.defaultSelectors.update(defaultFontSet);
        this.defaultFontSet = defaultFontSet;
    }

    FontSelector get(FontSelectorKey key) {
        if (this.update(null, null)) {
            return null;
        }
        return this.defaultSelectors.map.get(key);
    }

    FontSelector get(FontSelectorKey key, FontSet fontSet) {
        if (fontSet == null) {
            return this.get(key);
        }
        FontSetSelectors selectors = this.caches.get(fontSet.getId());
        if (selectors == null) {
            selectors = new FontSetSelectors();
            this.caches.put(fontSet.getId(), selectors);
        }
        if (this.update(selectors, fontSet)) {
            return null;
        }
        return selectors.map.get(key);
    }

    void put(FontSelectorKey key, FontSelector fontSelector) {
        this.update(null, null);
        this.defaultSelectors.map.put(key, fontSelector);
    }

    void put(FontSelectorKey key, FontSelector fontSelector, FontSet fontSet) {
        if (fontSet == null) {
            this.put(key, fontSelector);
        } else {
            FontSetSelectors selectors = this.caches.get(fontSet.getId());
            if (selectors == null) {
                selectors = new FontSetSelectors();
                this.caches.put(fontSet.getId(), selectors);
            }
            this.update(selectors, fontSet);
            selectors.map.put(key, fontSelector);
        }
    }

    private boolean update(FontSetSelectors selectors, FontSet fontSet) {
        boolean updated = false;
        if (this.defaultSelectors.update(this.defaultFontSet)) {
            updated = true;
        }
        if (selectors != null && selectors.update(fontSet)) {
            updated = true;
        }
        return updated;
    }

    private static class FontSetSelectors {
        final Map<FontSelectorKey, FontSelector> map = new HashMap<FontSelectorKey, FontSelector>();
        private int fontSetSize = -1;

        private FontSetSelectors() {
        }

        boolean update(FontSet fontSet) {
            assert (fontSet != null);
            if (this.fontSetSize == fontSet.size()) {
                return false;
            }
            this.map.clear();
            this.fontSetSize = fontSet.size();
            return true;
        }
    }
}

