/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.image.Jpeg2000ImageData;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.pdfa.PdfAConformanceException;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfA2Checker
extends PdfA1Checker {
    protected static final Set<PdfName> forbiddenAnnotations = new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.Sound, PdfName.Screen, PdfName.Movie));
    protected static final Set<PdfName> forbiddenActions = new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide, PdfName.SetOCGState, PdfName.Rendition, PdfName.Trans, PdfName.GoTo3DView));
    protected static final Set<PdfName> allowedBlendModes = new HashSet<PdfName>(Arrays.asList(PdfName.Normal, PdfName.Compatible, PdfName.Multiply, PdfName.Screen, PdfName.Overlay, PdfName.Darken, PdfName.Lighten, PdfName.ColorDodge, PdfName.ColorBurn, PdfName.HardLight, PdfName.SoftLight, PdfName.Difference, PdfName.Exclusion, PdfName.Hue, PdfName.Saturation, PdfName.Color, PdfName.Luminosity));
    static final int MAX_PAGE_SIZE = 14400;
    static final int MIN_PAGE_SIZE = 3;
    private static final int MAX_NUMBER_OF_DEVICEN_COLOR_COMPONENTS = 32;
    private static final long serialVersionUID = -5937712517954260687L;
    private boolean currentFillCsIsIccBasedCMYK = false;
    private boolean currentStrokeCsIsIccBasedCMYK = false;
    private Map<PdfName, PdfArray> separationColorSpaces = new HashMap<PdfName, PdfArray>();
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfA2Checker.class);
    private Set<PdfObject> transparencyObjects = new HashSet<PdfObject>();

    public PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    public void checkInlineImage(PdfStream inlineImage, PdfDictionary currentColorSpaces) {
        PdfObject filter = inlineImage.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt)) {
                throw new PdfAConformanceException("Crypt filter is not permitted inline image");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals((Object)PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("LZWDecode filter is not permitted");
                }
                if (!f.equals((Object)PdfName.Crypt)) continue;
                throw new PdfAConformanceException("Crypt filter is not permitted inline image");
            }
        }
        this.checkImage(inlineImage, currentColorSpaces);
    }

    @Override
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill) {
        this.checkColor(color, currentColorSpaces, fill, null);
    }

    @Override
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream contentStream) {
        if (color instanceof PatternColor) {
            PdfPattern pattern = ((PatternColor)color).getPattern();
            if (pattern instanceof PdfPattern.Shading) {
                PdfDictionary shadingDictionary = ((PdfPattern.Shading)pattern).getShading();
                PdfObject colorSpace = shadingDictionary.get(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)colorSpace), currentColorSpaces, true, true);
                final PdfDictionary extGStateDict = ((PdfDictionary)pattern.getPdfObject()).getAsDictionary(PdfName.ExtGState);
                CanvasGraphicsState gState = new CanvasGraphicsState(){
                    {
                        this.updateFromExtGState(new PdfExtGState(extGStateDict));
                    }
                };
                this.checkExtGState(gState, contentStream);
            } else if (pattern instanceof PdfPattern.Tiling) {
                this.checkContentStream((PdfStream)pattern.getPdfObject());
            }
        }
        super.checkColor(color, currentColorSpaces, fill, contentStream);
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        byte[] iccBytes;
        if (fill != null) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = false;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = false;
            }
        }
        if (colorSpace instanceof PdfSpecialCs.Separation) {
            PdfSpecialCs.Separation separation = (PdfSpecialCs.Separation)colorSpace;
            this.checkSeparationCS((PdfArray)separation.getPdfObject());
            if (checkAlternate) {
                this.checkColorSpace(separation.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.DeviceN) {
            PdfSpecialCs.DeviceN deviceN = (PdfSpecialCs.DeviceN)colorSpace;
            if (deviceN.getNumberOfComponents() > 32) {
                throw new PdfAConformanceException("The number of color components in DeviceN colorspace should not exceed {0}", 32);
            }
            PdfDictionary attributes = ((PdfArray)deviceN.getPdfObject()).getAsDictionary(4);
            PdfDictionary colorants = attributes.getAsDictionary(PdfName.Colorants);
            if (colorants != null) {
                for (Map.Entry entry : colorants.entrySet()) {
                    PdfArray separation = (PdfArray)entry.getValue();
                    this.checkSeparationInsideDeviceN(separation, ((PdfArray)deviceN.getPdfObject()).get(2), ((PdfArray)deviceN.getPdfObject()).get(3));
                }
            }
            if (checkAlternate) {
                this.checkColorSpace(deviceN.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.Indexed) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.Indexed)colorSpace).getBaseCs(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.UncoloredTilingPattern)colorSpace).getUnderlyingColorSpace(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Rgb) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultRGB, 3)) {
                this.rgbIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultCMYK, 4)) {
                this.cmykIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Gray && !this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultGray, 1)) {
            this.grayIsUsed = true;
        }
        if (fill != null && colorSpace instanceof PdfCieBasedCs.IccBased && "CMYK".equals(IccProfile.getIccColorSpaceName((byte[])(iccBytes = ((PdfArray)colorSpace.getPdfObject()).getAsStream(1).getBytes())))) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = true;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = true;
            }
        }
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState) {
        this.checkExtGState(extGState, null);
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState, PdfStream contentStream) {
        PdfObject bm;
        if (Integer.valueOf(1).equals(extGState.getOverprintMode())) {
            if (extGState.getFillOverprint() && this.currentFillCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
            if (extGState.getStrokeOverprint() && this.currentStrokeCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
        }
        if (extGState.getTransferFunction() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the tr key");
        }
        if (extGState.getHTP() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the HTP key");
        }
        PdfObject transferFunction2 = extGState.getTransferFunction2();
        if (transferFunction2 != null && !PdfName.Default.equals((Object)transferFunction2)) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the TR2 key with a value other than default");
        }
        if (extGState.getHalftone() instanceof PdfDictionary) {
            PdfDictionary halftoneDict = (PdfDictionary)extGState.getHalftone();
            Integer halftoneType = halftoneDict.getAsInt(PdfName.HalftoneType);
            if (halftoneType != 1 && halftoneType != 5) {
                throw new PdfAConformanceException("All halftones shall have halftonetype 1 or 5");
            }
            if (halftoneDict.containsKey(PdfName.HalftoneName)) {
                throw new PdfAConformanceException("Halftones shall not contain halftonename");
            }
        }
        this.checkRenderingIntent(extGState.getRenderingIntent());
        if (extGState.getSoftMask() != null && extGState.getSoftMask() instanceof PdfDictionary) {
            this.transparencyObjects.add((PdfObject)contentStream);
        }
        if (extGState.getStrokeOpacity() < 1.0f) {
            this.transparencyObjects.add((PdfObject)contentStream);
        }
        if (extGState.getFillOpacity() < 1.0f) {
            this.transparencyObjects.add((PdfObject)contentStream);
        }
        if ((bm = extGState.getBlendMode()) != null) {
            if (!PdfName.Normal.equals((Object)bm)) {
                this.transparencyObjects.add((PdfObject)contentStream);
            }
            if (bm instanceof PdfArray) {
                for (PdfObject b : (PdfArray)bm) {
                    this.checkBlendMode((PdfName)b);
                }
            } else if (bm instanceof PdfName) {
                this.checkBlendMode((PdfName)bm);
            }
        }
    }

    @Override
    protected void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        String encoding = trueTypeFont.getFontEncoding().getBaseEncoding();
        if (!"Cp1252".equals(encoding) && !"MacRoman".equals(encoding)) {
            throw new PdfAConformanceException("All non-symbolic TrueType fonts shall specify MacRomanEncoding or WinAnsiEncoding as the value of the Encoding entry in the font dictionary ", trueTypeFont);
        }
    }

    @Override
    protected double getMaxRealValue() {
        return 3.4028234663852886E38;
    }

    @Override
    protected int getMaxStringLength() {
        return Short.MAX_VALUE;
    }

    @Override
    protected void checkPdfArray(PdfArray array) {
    }

    @Override
    protected void checkPdfDictionary(PdfDictionary dictionary) {
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        PdfName subtype = annotDic.getAsName(PdfName.Subtype);
        if (subtype == null) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams(new Object[]{"null"});
        }
        if (forbiddenAnnotations.contains(subtype)) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams(new Object[]{subtype.getValue()});
        }
        if (!subtype.equals((Object)PdfName.Popup)) {
            PdfNumber f = annotDic.getAsNumber(PdfName.F);
            if (f == null) {
                throw new PdfAConformanceException("An annotation dictionary shall contain the f key");
            }
            int flags = f.intValue();
            if (!PdfA2Checker.checkFlag(flags, 4) || PdfA2Checker.checkFlag(flags, 2) || PdfA2Checker.checkFlag(flags, 1) || PdfA2Checker.checkFlag(flags, 32) || PdfA2Checker.checkFlag(flags, 256)) {
                throw new PdfAConformanceException("The f keys print flag bit shall be set to 1 and its hidden invisible noview and togglenoview flag bits shall be set to 0");
            }
            if (!(!subtype.equals((Object)PdfName.Text) || PdfA2Checker.checkFlag(flags, 8) && PdfA2Checker.checkFlag(flags, 16))) {
                throw new PdfAConformanceException("Text annotations should set the nozoom and norotate flag bits of the f key to 1");
            }
        }
        if (PdfName.Widget.equals((Object)subtype) && (annotDic.containsKey(PdfName.AA) || annotDic.containsKey(PdfName.A))) {
            throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a or aa entry");
        }
        if (annotDic.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("An annotation dictionary shall not contain aa key");
        }
        if (PdfA2Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annotDic.containsKey(PdfName.Contents)) {
            throw new PdfAConformanceException("Annotation of type {0} should have contents key").setMessageParams(new Object[]{subtype.getValue()});
        }
        PdfDictionary ap = annotDic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            if (ap.containsKey(PdfName.R) || ap.containsKey(PdfName.D)) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            PdfObject n = ap.get(PdfName.N);
            if (PdfName.Widget.equals((Object)subtype) && PdfName.Btn.equals((Object)annotDic.getAsName(PdfName.FT))) {
                if (n == null || !n.isDictionary()) {
                    throw new PdfAConformanceException("Appearance dictionary of widget subtype and btn field type shall contain only the n key with dictionary value");
                }
            } else if (n == null || !n.isStream()) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            this.checkResourcesOfAppearanceStreams(ap);
        } else {
            boolean isCorrectRect = false;
            PdfArray rect = annotDic.getAsArray(PdfName.Rect);
            if (rect != null && rect.size() == 4) {
                PdfNumber index0 = rect.getAsNumber(0);
                PdfNumber index1 = rect.getAsNumber(1);
                PdfNumber index2 = rect.getAsNumber(2);
                PdfNumber index3 = rect.getAsNumber(3);
                if (index0 != null && index1 != null && index2 != null && index3 != null && index0.floatValue() == index2.floatValue() && index1.floatValue() == index3.floatValue()) {
                    isCorrectRect = true;
                }
            }
            if (!(PdfName.Popup.equals((Object)subtype) || PdfName.Link.equals((Object)subtype) || isCorrectRect)) {
                throw new PdfAConformanceException("Every annotation shall have at least one appearance dictionary");
            }
        }
    }

    @Override
    protected void checkForm(PdfDictionary form) {
        if (form != null) {
            PdfBoolean needAppearances = form.getAsBoolean(PdfName.NeedAppearances);
            if (needAppearances != null && needAppearances.getValue()) {
                throw new PdfAConformanceException("Needappearances flag of the interactive form dictionary shall either not be presented or shall be false");
            }
            if (form.containsKey(PdfName.XFA)) {
                throw new PdfAConformanceException("The interactive form dictionary shall not contain the xfa key");
            }
            this.checkResources(form.getAsDictionary(PdfName.DR));
            PdfArray fields = form.getAsArray(PdfName.Fields);
            if (fields != null) {
                fields = this.getFormFields(fields);
                for (PdfObject field : fields) {
                    PdfDictionary fieldDic = (PdfDictionary)field;
                    this.checkResources(fieldDic.getAsDictionary(PdfName.DR));
                }
            }
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        PdfDictionary namesDictionary;
        if (catalogDict.containsKey(PdfName.NeedsRendering)) {
            throw new PdfAConformanceException("The catalog dictionary shall not contain the needsrendering key");
        }
        if (catalogDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain aa entry");
        }
        if (catalogDict.containsKey(PdfName.Requirements)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain a requirements entry");
        }
        PdfDictionary permissions = catalogDict.getAsDictionary(PdfName.Perms);
        if (permissions != null) {
            for (PdfName dictKey : permissions.keySet()) {
                if (PdfName.DocMDP.equals((Object)dictKey)) {
                    PdfArray references;
                    PdfDictionary signatureDict = permissions.getAsDictionary(PdfName.DocMDP);
                    if (signatureDict == null || (references = signatureDict.getAsArray(PdfName.Reference)) == null) continue;
                    for (int i = 0; i < references.size(); ++i) {
                        Iterator referenceDict = references.getAsDictionary(i);
                        if (!referenceDict.containsKey(PdfName.DigestLocation) && !referenceDict.containsKey(PdfName.DigestMethod) && !referenceDict.containsKey(PdfName.DigestValue)) continue;
                        throw new PdfAConformanceException("Signature references dictionary shall not contain digestlocation digestmethod digestvalue");
                    }
                    continue;
                }
                if (PdfName.UR3.equals((Object)dictKey)) continue;
                throw new PdfAConformanceException("No keys other than UR3 and DocMDP shall be present in a permissions dictionary");
            }
        }
        if ((namesDictionary = catalogDict.getAsDictionary(PdfName.Names)) != null && namesDictionary.containsKey(PdfName.AlternatePresentations)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain alternatepresentations names entry");
        }
        PdfDictionary oCProperties = catalogDict.getAsDictionary(PdfName.OCProperties);
        if (oCProperties != null) {
            PdfArray configs;
            ArrayList<PdfDictionary> configList = new ArrayList<PdfDictionary>();
            PdfDictionary d = oCProperties.getAsDictionary(PdfName.D);
            if (d != null) {
                configList.add(d);
            }
            if ((configs = oCProperties.getAsArray(PdfName.Configs)) != null) {
                for (PdfObject config : configs) {
                    configList.add((PdfDictionary)config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = oCProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    ocgs.add(ocg);
                }
            }
            HashSet<String> names = new HashSet<String>();
            for (PdfDictionary config : configList) {
                this.checkCatalogConfig(config, ocgs, names);
            }
        }
    }

    @Override
    protected void checkPageSize(PdfDictionary page) {
        PdfName[] boxNames;
        for (PdfName boxName : boxNames = new PdfName[]{PdfName.MediaBox, PdfName.CropBox, PdfName.TrimBox, PdfName.ArtBox, PdfName.BleedBox}) {
            Rectangle box = page.getAsRectangle(boxName);
            if (box == null) continue;
            float width = box.getWidth();
            float height = box.getHeight();
            if (!(width < 3.0f || width > 14400.0f || height < 3.0f) && !(height > 14400.0f)) continue;
            throw new PdfAConformanceException("The page less 3 units no greater 14400 in either direction");
        }
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.containsKey(PdfName.EF)) {
            PdfDictionary ef;
            PdfStream embeddedFile;
            if (!fileSpec.containsKey(PdfName.F) || !fileSpec.containsKey(PdfName.UF)) {
                throw new PdfAConformanceException("File specification dictionary shall contain f key and uf key");
            }
            if (!fileSpec.containsKey(PdfName.Desc)) {
                Logger logger = LoggerFactory.getLogger(PdfAChecker.class);
                logger.warn("File specification dictionary should contain desc key");
            }
            if ((embeddedFile = (ef = fileSpec.getAsDictionary(PdfName.EF)).getAsStream(PdfName.F)) == null) {
                throw new PdfAConformanceException("Ef key of file specification dictionary shall contain dictionary with valid f key");
            }
            Logger logger = LoggerFactory.getLogger(PdfAChecker.class);
            logger.warn("Embedded file shall be compliant with either ISO 19005-1 (PDF-A/1 standard) or ISO 19005-2 (PDF-A/2 standard). Please ensure that fact, because iText doesn't check embedded file.");
        }
    }

    @Override
    protected void checkPdfStream(PdfStream stream) {
        this.checkPdfDictionary((PdfDictionary)stream);
        if (stream.containsKey(PdfName.F) || stream.containsKey(PdfName.FFilter) || stream.containsKey(PdfName.FDecodeParams)) {
            throw new PdfAConformanceException("Stream object dictionary shall not contain the f ffilter or fdecodeparams keys");
        }
        PdfObject filter = stream.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            PdfName cryptFilterName;
            PdfDictionary decodeParams;
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt) && (decodeParams = stream.getAsDictionary(PdfName.DecodeParms)) != null && (cryptFilterName = decodeParams.getAsName(PdfName.Name)) != null && !cryptFilterName.equals((Object)PdfName.Identity)) {
                throw new PdfAConformanceException("Not identity crypt filter is not permitted");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfDictionary decodeParam;
                PdfName cryptFilterName;
                PdfArray decodeParams;
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals((Object)PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("LZWDecode filter is not permitted");
                }
                if (!f.equals((Object)PdfName.Crypt) || (decodeParams = stream.getAsArray(PdfName.DecodeParms)) == null || i >= decodeParams.size() || (cryptFilterName = (decodeParam = decodeParams.getAsDictionary(i)).getAsName(PdfName.Name)) == null || cryptFilterName.equals((Object)PdfName.Identity)) continue;
                throw new PdfAConformanceException("Not identity crypt filter is not permitted");
            }
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        PdfObject cs;
        if (pageDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("The page dictionary shall not contain aa entry");
        }
        if (pageDict.containsKey(PdfName.PresSteps)) {
            throw new PdfAConformanceException("The page dictionary shall not contain pressteps entry");
        }
        if (pageDict.containsKey(PdfName.Group) && PdfName.Transparency.equals((Object)pageDict.getAsDictionary(PdfName.Group).getAsName(PdfName.S)) && (cs = pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS)) != null) {
            PdfDictionary currentColorSpaces = pageResources.getAsDictionary(PdfName.ColorSpace);
            this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)cs), currentColorSpaces, true, null);
        }
    }

    @Override
    protected void checkPageTransparency(PdfDictionary pageDict, PdfDictionary pageResources) {
        if (this.pdfAOutputIntentColorSpace == null && this.transparencyObjects.size() > 0 && (pageDict.getAsDictionary(PdfName.Group) == null || pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS) == null)) {
            if (this.transparencyObjects.contains(pageDict)) {
                throw new PdfAConformanceException("If the document does not contain a OutputIntent, then page with transparency shall include the dictionary with Group key that include a CS with blending colour space");
            }
            this.checkContentsForTransparency(pageDict);
            this.checkXObjectsForTransparency(pageResources.getAsDictionary(PdfName.XObject));
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        int i;
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfObject destOutputProfile = null;
        for (i = 0; i < outputIntents.size() && destOutputProfile == null; ++i) {
            destOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
        }
        while (i < outputIntents.size()) {
            PdfObject otherDestOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
            if (otherDestOutputProfile != null && destOutputProfile != otherDestOutputProfile) {
                throw new PdfAConformanceException("If outputintents array has more than one entry with destoutputprofile key the same indirect object shall be used as the value of that object");
            }
            ++i;
        }
        if (destOutputProfile != null) {
            String deviceClass = IccProfile.getIccDeviceClass((byte[])((PdfStream)destOutputProfile).getBytes());
            if (!"prtr".equals(deviceClass) && !"mntr".equals(deviceClass)) {
                throw new PdfAConformanceException("Profile stream of outputintent shall be output profile (prtr) or monitor profile (mntr)");
            }
            String cs = IccProfile.getIccColorSpaceName((byte[])((PdfStream)destOutputProfile).getBytes());
            if (!("RGB ".equals(cs) || "CMYK".equals(cs) || "GRAY".equals(cs))) {
                throw new PdfAConformanceException("Output intent color space shall be either gray rgb or cmyk");
            }
        }
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        return forbiddenActions;
    }

    @Override
    protected Set<PdfName> getAllowedNamedActions() {
        return allowedNamedActions;
    }

    @Override
    protected void checkColorsUsages() {
        if ((this.rgbIsUsed || this.cmykIsUsed || this.grayIsUsed) && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("If device rgb cmyk gray used in file that file shall contain pdfa outputintent orDefaultRgb Cmyk Gray in usage context");
        }
        if (this.rgbIsUsed && !"RGB ".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("Devicergb may be used only if the file has a rgb pdfa outputIntent or defaultrgb in usage context");
        }
        if (this.cmykIsUsed && !"CMYK".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("Devicecmyk may be used only if the file has a cmyk pdfa outputIntent or defaultcmyk in usage context");
        }
    }

    @Override
    protected void checkImage(PdfStream image, PdfDictionary currentColorSpaces) {
        PdfColorSpace colorSpace = null;
        if (this.isAlreadyChecked((PdfDictionary)image)) {
            colorSpace = (PdfColorSpace)this.checkedObjectsColorspace.get(image);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            return;
        }
        PdfObject colorSpaceObj = image.get(PdfName.ColorSpace);
        if (colorSpaceObj != null) {
            colorSpace = PdfColorSpace.makeColorSpace((PdfObject)colorSpaceObj);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            this.checkedObjectsColorspace.put(image, colorSpace);
        }
        if (image.containsKey(PdfName.Alternates)) {
            throw new PdfAConformanceException("An image dictionary shall not contain alternates key");
        }
        if (image.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("An image dictionary shall not contain opi key");
        }
        if (image.containsKey(PdfName.Interpolate) && image.getAsBool(PdfName.Interpolate).booleanValue()) {
            throw new PdfAConformanceException("The value of interpolate key shall not be true");
        }
        this.checkRenderingIntent(image.getAsName(PdfName.Intent));
        if (image.getAsStream(PdfName.SMask) != null) {
            this.transparencyObjects.add((PdfObject)image);
        }
        if (image.containsKey(PdfName.SMaskInData) && image.getAsInt(PdfName.SMaskInData) > 0) {
            this.transparencyObjects.add((PdfObject)image);
        }
        if (PdfName.JPXDecode.equals((Object)image.get(PdfName.Filter))) {
            Jpeg2000ImageData jpgImage = (Jpeg2000ImageData)ImageDataFactory.createJpeg2000((byte[])image.getBytes(false));
            Jpeg2000ImageData.Parameters params = jpgImage.getParameters();
            if (!params.isJp2) {
                throw new PdfAConformanceException("Only jpx baseline set of features shall be used");
            }
            if (params.numOfComps != 1 && params.numOfComps != 3 && params.numOfComps != 4) {
                throw new PdfAConformanceException("The number of colour channels in the jpeg2000 data shall be 1, 3 or 4");
            }
            if (params.colorSpecBoxes != null && params.colorSpecBoxes.size() > 1) {
                int numOfApprox0x01 = 0;
                for (Jpeg2000ImageData.ColorSpecBox colorSpecBox : params.colorSpecBoxes) {
                    if (colorSpecBox.getApprox() == 1) {
                        if (++numOfApprox0x01 == 1 && colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                            throw new PdfAConformanceException("The value of the meth entry in colr box shall be 1, 2 or 3");
                        }
                        if (image.get(PdfName.ColorSpace) == null) {
                            switch (colorSpecBox.getEnumCs()) {
                                case 1: {
                                    PdfDeviceCs.Gray deviceGrayCs = new PdfDeviceCs.Gray();
                                    this.checkColorSpace((PdfColorSpace)deviceGrayCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceGrayCs);
                                    break;
                                }
                                case 3: {
                                    PdfDeviceCs.Rgb deviceRgbCs = new PdfDeviceCs.Rgb();
                                    this.checkColorSpace((PdfColorSpace)deviceRgbCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceRgbCs);
                                    break;
                                }
                                case 12: {
                                    PdfDeviceCs.Cmyk deviceCmykCs = new PdfDeviceCs.Cmyk();
                                    this.checkColorSpace((PdfColorSpace)deviceCmykCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceCmykCs);
                                }
                            }
                        }
                    }
                    if (colorSpecBox.getEnumCs() != 19) continue;
                    throw new PdfAConformanceException("jpeg2000 enumerated colour space 19 (CIEJab) shall not be used");
                }
                if (numOfApprox0x01 != 1) {
                    throw new PdfAConformanceException("Exactly one colour space specification shall have the value 0x01 in the approx field");
                }
            }
            if (jpgImage.getBpc() < 1 || jpgImage.getBpc() > 38) {
                throw new PdfAConformanceException("The bit-depth of the jpeg2000 data shall have a value in the range 1 to 38");
            }
            if (params.bpcBoxData != null) {
                throw new PdfAConformanceException("All colour channels in the jpeg2000 data shall have the same bit-depth");
            }
        }
    }

    @Override
    protected void checkFormXObject(PdfStream form) {
        this.checkFormXObject(form, null);
    }

    protected void checkFormXObject(PdfStream form, PdfStream contentStream) {
        if (this.isAlreadyChecked((PdfDictionary)form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain opi key");
        }
        if (form.containsKey(PdfName.PS)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain PS key");
        }
        if (PdfName.PS.equals((Object)form.getAsName(PdfName.Subtype2))) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain subtype2 key with a value of PS");
        }
        if (form.containsKey(PdfName.Group) && PdfName.Transparency.equals((Object)form.getAsDictionary(PdfName.Group).getAsName(PdfName.S))) {
            if (contentStream != null) {
                this.transparencyObjects.add((PdfObject)contentStream);
            } else {
                this.transparencyObjects.add((PdfObject)form);
            }
            PdfObject cs = form.getAsDictionary(PdfName.Group).get(PdfName.CS);
            PdfDictionary resources = form.getAsDictionary(PdfName.Resources);
            if (cs != null && resources != null) {
                PdfDictionary currentColorSpaces = resources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)cs), currentColorSpaces, true, null);
            }
        }
        this.checkResources(form.getAsDictionary(PdfName.Resources));
        this.checkContentStream(form);
    }

    private void checkContentsForTransparency(PdfDictionary pageDict) {
        PdfStream contentStream = pageDict.getAsStream(PdfName.Contents);
        if (contentStream != null && this.transparencyObjects.contains(contentStream)) {
            throw new PdfAConformanceException("If the document does not contain a OutputIntent, then page with transparency shall include the dictionary with Group key that include a CS with blending colour space");
        }
        PdfArray contentSteamArray = pageDict.getAsArray(PdfName.Contents);
        if (contentSteamArray != null) {
            for (int i = 0; i < contentSteamArray.size(); ++i) {
                if (!this.transparencyObjects.contains(contentSteamArray.get(i))) continue;
                throw new PdfAConformanceException("If the document does not contain a OutputIntent, then page with transparency shall include the dictionary with Group key that include a CS with blending colour space");
            }
        }
    }

    private void checkXObjectsForTransparency(PdfDictionary dictionary) {
        if (dictionary != null) {
            for (PdfName key : dictionary.keySet()) {
                PdfStream xObject = dictionary.getAsStream(key);
                if (this.transparencyObjects.contains(xObject)) {
                    throw new PdfAConformanceException("If the document does not contain a OutputIntent, then page with transparency shall include the dictionary with Group key that include a CS with blending colour space");
                }
                if (xObject.getAsDictionary(PdfName.Resources) == null || xObject.getAsDictionary(PdfName.Resources).getAsDictionary(PdfName.XObject) == null) continue;
                this.checkXObjectsForTransparency(xObject.getAsDictionary(PdfName.Resources).getAsDictionary(PdfName.XObject));
            }
        }
    }

    private void checkBlendMode(PdfName blendMode) {
        if (!allowedBlendModes.contains(blendMode)) {
            throw new PdfAConformanceException("Only standard blend modes shall be used for the value of the BM key in an extended graphic state dictionary");
        }
    }

    private void checkSeparationInsideDeviceN(PdfArray separation, PdfObject deviceNColorSpace, PdfObject deviceNTintTransform) {
        if (!this.isAltCSIsTheSame(separation.get(2), deviceNColorSpace) || !deviceNTintTransform.equals(separation.get(3))) {
            Logger logger = LoggerFactory.getLogger(PdfAChecker.class);
            logger.warn("TintTransform and alternateSpace of separation arrays in the colorants of deviceN should be consistent with same attributes of deviceN");
        }
        this.checkSeparationCS(separation);
    }

    private void checkSeparationCS(PdfArray separation) {
        if (this.separationColorSpaces.containsKey(separation.getAsName(0))) {
            boolean tintTransformIsTheSame;
            PdfArray sameNameSeparation = this.separationColorSpaces.get(separation.getAsName(0));
            PdfObject cs1 = separation.get(2);
            PdfObject cs2 = sameNameSeparation.get(2);
            boolean altCSIsTheSame = this.isAltCSIsTheSame(cs1, cs2);
            PdfObject f1Obj = separation.get(3);
            PdfObject f2Obj = sameNameSeparation.get(3);
            boolean bothAllowedType = f1Obj.getType() == f2Obj.getType() && (f1Obj.isDictionary() || f1Obj.isStream());
            boolean bl = tintTransformIsTheSame = bothAllowedType && f1Obj.equals(f2Obj);
            if (!altCSIsTheSame || !tintTransformIsTheSame) {
                throw new PdfAConformanceException("TintTransform and alternateSpace shall be the same for the all separation cs with the same name");
            }
        } else {
            this.separationColorSpaces.put(separation.getAsName(0), separation);
        }
    }

    private boolean isAltCSIsTheSame(PdfObject cs1, PdfObject cs2) {
        boolean altCSIsTheSame = false;
        if (cs1 instanceof PdfName) {
            altCSIsTheSame = cs1.equals(cs2);
        } else if (cs1 instanceof PdfArray && cs2 instanceof PdfArray) {
            altCSIsTheSame = ((PdfArray)cs1).get(0).equals(((PdfArray)cs1).get(0));
        }
        return altCSIsTheSame;
    }

    private void checkCatalogConfig(PdfDictionary config, HashSet<PdfObject> ocgs, HashSet<String> names) {
        PdfString name = config.getAsString(PdfName.Name);
        if (name == null) {
            throw new PdfAConformanceException("Optional content configuration dictionary shall contain name entry");
        }
        if (!names.add(name.toUnicodeString())) {
            throw new PdfAConformanceException("Value of name entry shall be unique among all optional content configuration dictionaries");
        }
        if (config.containsKey(PdfName.AS)) {
            throw new PdfAConformanceException("The as key shall not appear in any optional content configuration dictionary");
        }
        PdfArray orderArray = config.getAsArray(PdfName.Order);
        if (orderArray != null) {
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            this.fillOrderRecursively(orderArray, order);
            if (!order.equals(ocgs)) {
                throw new PdfAConformanceException("Order array shall contain references to all ocgs");
            }
        }
    }

    private void fillOrderRecursively(PdfArray orderArray, Set<PdfObject> order) {
        for (PdfObject orderItem : orderArray) {
            if (!orderItem.isArray()) {
                order.add(orderItem);
                continue;
            }
            this.fillOrderRecursively((PdfArray)orderItem, order);
        }
    }

    private boolean checkDefaultCS(PdfDictionary currentColorSpaces, Boolean fill, PdfName defaultCsName, int numOfComponents) {
        if (currentColorSpaces == null) {
            return false;
        }
        if (!currentColorSpaces.containsKey(defaultCsName)) {
            return false;
        }
        PdfObject defaultCsObj = currentColorSpaces.get(defaultCsName);
        PdfColorSpace defaultCs = PdfColorSpace.makeColorSpace((PdfObject)defaultCsObj);
        if (defaultCs instanceof PdfDeviceCs) {
            throw new PdfAConformanceException("Color space {0} shall be device independent").setMessageParams(new Object[]{defaultCsName.toString()});
        }
        if (defaultCs.getNumberOfComponents() != numOfComponents) {
            throw new PdfAConformanceException("Color space {0} shall have {1} components").setMessageParams(new Object[]{defaultCsName.getValue(), numOfComponents});
        }
        this.checkColorSpace(defaultCs, currentColorSpaces, false, fill);
        return true;
    }

    @Override
    public void checkFontGlyphs(PdfFont font, PdfStream contentStream) {
        if (font instanceof PdfType3Font) {
            for (int i = 0; i < ((PdfType3Font)font).getNumberOfGlyphs(); ++i) {
                int unicode = ((PdfType3Font)font).getFontEncoding().getUnicode(i);
                if (unicode == -1) continue;
                this.checkFormXObject(((PdfType3Font)font).getType3Glyph(unicode).getContentStream(), contentStream);
            }
        }
    }
}

