/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.selector.item.CssAttributeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssClassSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssIdSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoElementSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssSeparatorSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssTagSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CssSelectorParser {
    private static final Set<String> LEGACY_PSEUDO_ELEMENTS;
    private static final String SELECTOR_PATTERN_STR = "(\\*)|([_a-zA-Z][\\w-]*)|(\\.[_a-zA-Z][\\w-]*)|(#[_a-z][\\w-]*)|(\\[[_a-zA-Z][\\w-]*(([~^$*|])?=((\"[^\"]+\")|([^\"]+)|('[^']+')|(\"\")|('')))?\\])|(::?[a-zA-Z-]*)|( )|(\\+)|(>)|(~)";
    private static final Pattern selectorPattern;

    private CssSelectorParser() {
    }

    public static List<ICssSelectorItem> parseSelectorItems(String selector) {
        ArrayList<ICssSelectorItem> selectorItems = new ArrayList<ICssSelectorItem>();
        Matcher match = selectorPattern.matcher(selector);
        boolean tagSelectorDescription = false;
        while (match.find()) {
            String selectorItem = match.group(0);
            char firstChar = selectorItem.charAt(0);
            switch (firstChar) {
                case '#': {
                    selectorItems.add(new CssIdSelectorItem(selectorItem.substring(1)));
                    break;
                }
                case '.': {
                    selectorItems.add(new CssClassSelectorItem(selectorItem.substring(1)));
                    break;
                }
                case '[': {
                    selectorItems.add(new CssAttributeSelectorItem(selectorItem));
                    break;
                }
                case ':': {
                    CssSelectorParser.appendPseudoSelector(selectorItems, selectorItem, match, selector);
                    break;
                }
                case ' ': 
                case '+': 
                case '>': 
                case '~': {
                    if (selectorItems.size() == 0) {
                        throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token detected in the start of the selector string: {0}", (Object[])new Object[]{Character.valueOf(firstChar)}));
                    }
                    ICssSelectorItem lastItem = (ICssSelectorItem)selectorItems.get(selectorItems.size() - 1);
                    CssSeparatorSelectorItem curItem = new CssSeparatorSelectorItem(firstChar);
                    if (lastItem instanceof CssSeparatorSelectorItem) {
                        if (curItem.getSeparator() == ' ') break;
                        if (((CssSeparatorSelectorItem)lastItem).getSeparator() == ' ') {
                            selectorItems.set(selectorItems.size() - 1, curItem);
                            break;
                        }
                        throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid selector description. Two consequent characters occurred: {0}, {1}", (Object[])new Object[]{Character.valueOf(((CssSeparatorSelectorItem)lastItem).getSeparator()), Character.valueOf(curItem.getSeparator())}));
                    }
                    selectorItems.add(curItem);
                    tagSelectorDescription = false;
                    break;
                }
                default: {
                    if (tagSelectorDescription) {
                        throw new IllegalStateException("Invalid selector string");
                    }
                    tagSelectorDescription = true;
                    selectorItems.add(new CssTagSelectorItem(selectorItem));
                }
            }
        }
        if (selectorItems.size() == 0) {
            throw new IllegalArgumentException("Selector declaration is invalid");
        }
        return selectorItems;
    }

    private static void appendPseudoSelector(List<ICssSelectorItem> selectorItems, String pseudoSelector, Matcher match, String source) {
        pseudoSelector = pseudoSelector.toLowerCase();
        if ((pseudoSelector = CssSelectorParser.handleBracketsOfPseudoSelector(pseudoSelector, match, source)).startsWith("::")) {
            selectorItems.add(new CssPseudoElementSelectorItem(pseudoSelector.substring(2)));
        } else if (pseudoSelector.startsWith(":") && LEGACY_PSEUDO_ELEMENTS.contains(pseudoSelector.substring(1))) {
            selectorItems.add(new CssPseudoElementSelectorItem(pseudoSelector.substring(1)));
        } else {
            CssPseudoClassSelectorItem pseudoClassSelectorItem = CssPseudoClassSelectorItem.create(pseudoSelector.substring(1));
            if (pseudoClassSelectorItem == null) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Unsupported pseudo css selector: {0}", (Object[])new Object[]{pseudoSelector}));
            }
            selectorItems.add(pseudoClassSelectorItem);
        }
    }

    private static String handleBracketsOfPseudoSelector(String pseudoSelector, Matcher match, String source) {
        int start = match.start() + pseudoSelector.length();
        if (start < source.length() && source.charAt(start) == '(') {
            int curr;
            int bracketDepth = 1;
            for (curr = start + 1; bracketDepth > 0 && curr < source.length(); ++curr) {
                if (source.charAt(curr) == '(') {
                    ++bracketDepth;
                    continue;
                }
                if (source.charAt(curr) == ')') {
                    --bracketDepth;
                    continue;
                }
                if (source.charAt(curr) != '\"' && source.charAt(curr) != '\'') continue;
                curr = CssUtils.findNextUnescapedChar(source, source.charAt(curr), curr + 1);
            }
            if (bracketDepth == 0) {
                match.region(curr, source.length());
                pseudoSelector = pseudoSelector + source.substring(start, curr);
            }
        }
        return pseudoSelector;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("first-line");
        tempSet.add("first-letter");
        tempSet.add("before");
        tempSet.add("after");
        LEGACY_PSEUDO_ELEMENTS = Collections.unmodifiableSet(tempSet);
        selectorPattern = Pattern.compile(SELECTOR_PATTERN_STR);
    }
}

