/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate;

import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.validate.ICssDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.ArrayDataTypeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBackgroundValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBlendModeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssColorValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssEnumValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssLengthValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssNumberValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssPercentageValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssQuotesValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssTransformValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.MultiTypeDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.SingleTypeDeclarationValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CssDeclarationValidationMaster {
    private static final Map<String, ICssDeclarationValidator> DEFAULT_VALIDATORS;

    private CssDeclarationValidationMaster() {
    }

    public static boolean checkDeclaration(CssDeclaration declaration) {
        ICssDeclarationValidator validator = DEFAULT_VALIDATORS.get(declaration.getProperty());
        return validator == null || validator.isValid(declaration);
    }

    static {
        MultiTypeDeclarationValidator colorCommonValidator = new MultiTypeDeclarationValidator(new CssEnumValidator("transparent", "initial", "inherit", "currentcolor"), new CssColorValidator());
        CssEnumValidator normalValidator = new CssEnumValidator("normal");
        CssEnumValidator relativeSizeValidator = new CssEnumValidator("larger", "smaller");
        CssEnumValidator absoluteSizeValidator = new CssEnumValidator(new String[0]);
        absoluteSizeValidator.addAllowedValues(CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.keySet());
        CssEnumValidator inheritInitialUnsetValidator = new CssEnumValidator("inherit", "initial", "unset");
        DEFAULT_VALIDATORS = new HashMap<String, ICssDeclarationValidator>();
        DEFAULT_VALIDATORS.put("background-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-bottom-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-top-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-left-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-right-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("float", new SingleTypeDeclarationValidator(new CssEnumValidator("left", "right", "none", "inherit", "center")));
        DEFAULT_VALIDATORS.put("page-break-before", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("page-break-after", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("quotes", new MultiTypeDeclarationValidator(new CssEnumValidator("initial", "inherit", "none"), new CssQuotesValidator()));
        DEFAULT_VALIDATORS.put("transform", new SingleTypeDeclarationValidator(new CssTransformValidator()));
        DEFAULT_VALIDATORS.put("font-size", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), relativeSizeValidator, absoluteSizeValidator));
        DEFAULT_VALIDATORS.put("word-spacing", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), normalValidator));
        DEFAULT_VALIDATORS.put("letter-spacing", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), normalValidator));
        DEFAULT_VALIDATORS.put("text-indent", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), new CssPercentageValueValidator(true), new CssEnumValidator("each-line", "hanging", "hanging each-line")));
        DEFAULT_VALIDATORS.put("line-height", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("column-gap", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("row-gap", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("flex-grow", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("flex-shrink", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), inheritInitialUnsetValidator));
        CssEnumValidator flexBasisEnumValidator = new CssEnumValidator("auto", "content", "min-content", "max-content", "fit-content");
        DEFAULT_VALIDATORS.put("flex-basis", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), flexBasisEnumValidator));
        DEFAULT_VALIDATORS.put("background-repeat", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-repeat")));
        DEFAULT_VALIDATORS.put("background-image", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-image")));
        DEFAULT_VALIDATORS.put("background-position-x", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-x")));
        DEFAULT_VALIDATORS.put("background-position-y", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-y")));
        DEFAULT_VALIDATORS.put("background-size", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-size")));
        DEFAULT_VALIDATORS.put("background-clip", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-clip")));
        DEFAULT_VALIDATORS.put("background-origin", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-origin")));
        DEFAULT_VALIDATORS.put("background-blend-mode", new SingleTypeDeclarationValidator(new ArrayDataTypeValidator(new CssBlendModeValidator())));
        DEFAULT_VALIDATORS.put("overflow-wrap", new MultiTypeDeclarationValidator(new CssEnumValidator("anywhere", "break-word"), normalValidator, inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("word-break", new MultiTypeDeclarationValidator(new CssEnumValidator("break-all", "keep-all", "break-word"), normalValidator, inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("flex-direction", new MultiTypeDeclarationValidator(new CssEnumValidator("row", "row-reverse", "column", "column-reverse"), inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("flex-wrap", new MultiTypeDeclarationValidator(new CssEnumValidator("nowrap", "wrap", "wrap-reverse"), inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("align-items", new MultiTypeDeclarationValidator(normalValidator, new CssEnumValidator(Arrays.asList("baseline"), Arrays.asList("first", "last")), new CssEnumValidator(Arrays.asList("stretch", "center", "start", "end", "flex-start", "flex-end", "self-start", "self-end"), Arrays.asList("safe", "unsafe")), inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("justify-content", new MultiTypeDeclarationValidator(new CssEnumValidator(Arrays.asList("space-around", "space-between", "space-evenly", "stretch", "normal", "left", "right")), new CssEnumValidator(Arrays.asList("center", "start", "flex-start", "self-start", "end", "flex-end", "self-end"), Arrays.asList("safe", "unsafe")), inheritInitialUnsetValidator));
        DEFAULT_VALIDATORS.put("justify-items", new MultiTypeDeclarationValidator(normalValidator, new CssEnumValidator(Arrays.asList("baseline"), Arrays.asList("first", "last")), new CssEnumValidator(Arrays.asList("stretch", "center", "start", "end", "flex-start", "flex-end", "self-start", "self-end", "left", "right"), Arrays.asList("safe", "unsafe")), new CssEnumValidator("legacy", "legacy left", "legacy right", "legacy center"), inheritInitialUnsetValidator));
    }
}

