/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl.datatype;

import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.ICssDataTypeValidator;

public class CssPercentageValueValidator
implements ICssDataTypeValidator {
    private final boolean allowedNegative;

    public CssPercentageValueValidator(boolean allowedNegative) {
        this.allowedNegative = allowedNegative;
    }

    @Override
    public boolean isValid(String objectString) {
        if (objectString == null) {
            return false;
        }
        if ("initial".equals(objectString) || "inherit".equals(objectString) || "unset".equals(objectString)) {
            return true;
        }
        if (!CssTypesValidationUtils.isPercentageValue(objectString)) {
            return false;
        }
        if (CssTypesValidationUtils.isNegativeValue(objectString) && !CssTypesValidationUtils.isZero(objectString)) {
            return this.allowedNegative;
        }
        return true;
    }
}

