/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.GreekList;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.RomanList;
import com.itextpdf.text.ZapfDingbatsList;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.net.ImageRetrieve;
import com.itextpdf.tool.xml.net.exc.NoImageException;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

public class ListStyleTypeCssApplier {
    private final CssUtils utils = CssUtils.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(ListStyleTypeCssApplier.class);

    public List apply(List list, Tag t, HtmlPipelineContext context) {
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        List lst = list;
        Map<String, String> css = t.getCSS();
        String styleType = css.get("list-style-type");
        BaseColor color = HtmlUtilities.decodeColor((String)css.get("color"));
        if (null == color) {
            color = BaseColor.BLACK;
        }
        if (null != styleType) {
            Font font;
            Chunk symbol;
            if (styleType.equalsIgnoreCase("none")) {
                lst.setLettered(false);
                lst.setNumbered(false);
                lst.setListSymbol("");
            } else if ("decimal".equalsIgnoreCase(styleType)) {
                lst = new List(true);
            } else if ("disc".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(108);
                lst.setAutoindent(false);
                lst.setSymbolIndent(7.75f);
                symbol = lst.getSymbol();
                symbol.setTextRise(1.5f);
                font = symbol.getFont();
                font.setSize(4.5f);
                font.setColor(color);
            } else if ("square".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(110);
                this.shrinkSymbol(lst, fontSize, color);
            } else if ("circle".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(109);
                lst.setAutoindent(false);
                lst.setSymbolIndent(7.75f);
                symbol = lst.getSymbol();
                symbol.setTextRise(1.5f);
                font = symbol.getFont();
                font.setSize(4.5f);
            } else if ("lower-roman".equals(styleType)) {
                lst = new RomanList(true, 0);
                this.synchronizeSymbol(fontSize, lst, color);
                lst.setAutoindent(true);
            } else if ("upper-roman".equals(styleType)) {
                lst = new RomanList(false, 0);
                lst.setAutoindent(true);
                this.synchronizeSymbol(fontSize, lst, color);
            } else if ("lower-greek".equals(styleType)) {
                lst = new GreekList(true, 0);
                this.synchronizeSymbol(fontSize, lst, color);
                lst.setAutoindent(true);
            } else if ("upper-greek".equals(styleType)) {
                lst = new GreekList(false, 0);
                this.synchronizeSymbol(fontSize, lst, color);
                lst.setAutoindent(true);
            } else if ("lower-alpha".equals(styleType) || "lower-latin".equals(styleType)) {
                lst = new List(true, true);
                this.synchronizeSymbol(fontSize, lst, color);
                lst.setLowercase(true);
                lst.setAutoindent(true);
            } else if ("upper-alpha".equals(styleType) || "upper-latin".equals(styleType)) {
                lst = new List(true, true);
                this.synchronizeSymbol(fontSize, lst, color);
                lst.setLowercase(false);
                lst.setAutoindent(true);
            }
        } else if (t.getName().equalsIgnoreCase("ol")) {
            lst = new List(true);
            String type = t.getAttributes().get("type");
            if (type != null) {
                if (type.equals("A")) {
                    lst.setLettered(true);
                } else if (type.equals("a")) {
                    lst.setLettered(true);
                    lst.setLowercase(true);
                }
            }
            this.synchronizeSymbol(fontSize, lst, color);
            lst.setAutoindent(true);
        } else if (t.getName().equalsIgnoreCase("ul")) {
            lst = new List(false);
            this.shrinkSymbol(lst, fontSize, color);
        }
        if (null != css.get("list-style-image") && !css.get("list-style-image").equalsIgnoreCase("none")) {
            lst = new List();
            String url = this.utils.extractUrl(css.get("list-style-image"));
            try {
                Image img = new ImageRetrieve(context.getResourcesRootPath(), context.getImageProvider()).retrieveImage(url);
                lst.setListSymbol(new Chunk(img, 0.0f, 0.0f, false));
                lst.setSymbolIndent(img.getWidth());
                if (LOG.isLogging(Level.TRACE)) {
                    LOG.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.list"), url));
                }
            }
            catch (NoImageException e) {
                if (LOG.isLogging(Level.ERROR)) {
                    LOG.error(String.format(LocaleMessages.getInstance().getMessage("html.tag.img.failed"), url), (Exception)e);
                }
                lst = new List(false);
            }
            lst.setAutoindent(false);
        }
        lst.setAlignindent(false);
        float leftIndent = 0.0f;
        leftIndent = null != css.get("list-style-position") && css.get("list-style-position").equalsIgnoreCase("inside") ? (leftIndent += 30.0f) : (leftIndent += 15.0f);
        leftIndent += css.get("margin-left") != null ? this.utils.parseValueToPt(css.get("margin-left"), fontSize) : 0.0f;
        lst.setIndentationLeft(leftIndent += css.get("padding-left") != null ? this.utils.parseValueToPt(css.get("padding-left"), fontSize) : 0.0f);
        String startAtr = t.getAttributes().get("start");
        if (startAtr != null) {
            try {
                int start = Integer.parseInt(startAtr);
                lst.setFirst(start);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return lst;
    }

    private void synchronizeSymbol(float fontSize, List lst, BaseColor color) {
        Font font = lst.getSymbol().getFont();
        font.setSize(fontSize);
        font.setColor(color);
        lst.setSymbolIndent(fontSize);
    }

    private void shrinkSymbol(List lst, float fontSize, BaseColor color) {
        lst.setSymbolIndent(12.0f);
        Chunk symbol = lst.getSymbol();
        Font font = symbol.getFont();
        font.setSize(fontSize);
        font.setColor(color);
    }

    public Element apply(List e, Tag t) {
        return this.apply(e, t, null);
    }
}

