/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class MapperAnnotationPlugin
extends BasePlugin {
    private static final Map<String, String> ANNOTATION_IMPORTS = new HashMap<String, String>();
    private List<String> annotations;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.annotations = new ArrayList<String>();
        Properties properties = this.getProperties();
        boolean findMapper = false;
        for (Object key : properties.keySet()) {
            String annotation = key.toString().trim();
            if (annotation.startsWith("@Mapper")) {
                findMapper = true;
            }
            if (!StringUtility.isTrue((String)properties.getProperty(key.toString()))) continue;
            this.annotations.add(annotation);
        }
        if (!findMapper) {
            this.annotations.add(0, "@Mapper");
        }
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (String annotation : this.annotations) {
            if (annotation.equals("@Mapper")) {
                if (introspectedTable.getTargetRuntime() != IntrospectedTable.TargetRuntime.MYBATIS3) continue;
                interfaze.addImportedType(new FullyQualifiedJavaType(ANNOTATION_IMPORTS.get(annotation)));
                interfaze.addAnnotation(annotation);
                continue;
            }
            if (ANNOTATION_IMPORTS.get(annotation) == null) continue;
            interfaze.addImportedType(new FullyQualifiedJavaType(ANNOTATION_IMPORTS.get(annotation)));
            interfaze.addAnnotation(annotation);
        }
        return true;
    }

    static {
        ANNOTATION_IMPORTS.put("@Mapper", "org.apache.ibatis.annotations.Mapper");
        ANNOTATION_IMPORTS.put("@Repository", "org.springframework.stereotype.Repository");
    }
}

