/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.IIncrementPluginHook;
import com.itfsw.mybatis.generator.plugins.utils.hook.IIncrementsPluginHook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.StringUtility;

public class XmlElementGeneratorTools {
    public static Element getSelectKey(IntrospectedColumn introspectedColumn, GeneratedKey generatedKey) {
        return XmlElementGeneratorTools.getSelectKey(introspectedColumn, generatedKey, null);
    }

    public static Element getSelectKey(IntrospectedColumn introspectedColumn, GeneratedKey generatedKey, String prefix) {
        String identityColumnType = introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName();
        XmlElement answer = new XmlElement("selectKey");
        answer.addAttribute(new Attribute("resultType", identityColumnType));
        answer.addAttribute(new Attribute("keyProperty", (prefix == null ? "" : prefix) + introspectedColumn.getJavaProperty()));
        answer.addAttribute(new Attribute("order", generatedKey.getMyBatis3Order()));
        answer.addElement((Element)new TextElement(generatedKey.getRuntimeSqlStatement()));
        return answer;
    }

    public static Element getBaseColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBaseColumnListId()));
        return answer;
    }

    public static Element getBlobColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBlobColumnListId()));
        return answer;
    }

    public static Element getExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getExampleWhereClauseId()));
        ifElement.addElement((Element)includeElement);
        return ifElement;
    }

    public static Element getUpdateByExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getMyBatis3UpdateByExampleWhereClauseId()));
        ifElement.addElement((Element)includeElement);
        return ifElement;
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable) {
        XmlElementGeneratorTools.useGeneratedKeys(element, introspectedTable, null);
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable, String prefix) {
        IntrospectedColumn introspectedColumn;
        GeneratedKey gk = introspectedTable.getGeneratedKey();
        if (gk != null && (introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, gk.getColumn())) != null) {
            element.addAttribute(new Attribute("useGeneratedKeys", "true"));
            element.addAttribute(new Attribute("keyProperty", (prefix == null ? "" : prefix) + introspectedColumn.getJavaProperty()));
            element.addAttribute(new Attribute("keyColumn", introspectedColumn.getActualColumnName()));
        }
    }

    public static List<Element> generateKeys(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeys(columns, false);
    }

    public static List<Element> generateKeys(List<IntrospectedColumn> columns, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, null, bracket, 1);
    }

    public static XmlElement generateKeysSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeysSelective(columns, null);
    }

    public static XmlElement generateKeysSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateKeysSelective(columns, prefix, true);
    }

    public static XmlElement generateKeysSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, bracket, 1);
    }

    public static List<Element> generateValues(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValues(columns, null);
    }

    public static List<Element> generateValues(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValues(columns, prefix, true);
    }

    public static List<Element> generateValues(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, bracket, 2);
    }

    public static XmlElement generateValuesSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValuesSelective(columns, null);
    }

    public static XmlElement generateValuesSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValuesSelective(columns, prefix, true);
    }

    public static XmlElement generateValuesSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, bracket, 2);
    }

    public static List<Element> generateSets(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSets(columns, null);
    }

    public static List<Element> generateSets(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, false, 3);
    }

    public static XmlElement generateSetsSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSetsSelective(columns, null);
    }

    public static XmlElement generateSetsSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, false, 3);
    }

    public static List<Element> generateUpsertKeys(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, true, 1, true);
    }

    public static List<Element> generateUpsertValues(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, bracket, 2, true);
    }

    public static List<Element> generateUpsertSets(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, false, 3, true);
    }

    private static List<Element> generateCommColumns(List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, bracket, type, false);
    }

    private static List<Element> generateCommColumns(List<IntrospectedColumn> columns, String prefix, boolean bracket, int type, boolean upsert) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (upsert && XmlElementGeneratorTools.hasIdentityAndGeneratedAlwaysColumns(columns)) {
            XmlElement trimEle = XmlElementGeneratorTools.generateTrim(bracket);
            for (IntrospectedColumn introspectedColumn : columns) {
                if (introspectedColumn.isGeneratedAlways() || introspectedColumn.isIdentity()) {
                    XmlElementGeneratorTools.generateSelectiveToTrimEleTo(trimEle, introspectedColumn, prefix, type);
                    continue;
                }
                if (type == 3 && PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedColumn, prefix) != null) {
                    trimEle.addElement((Element)PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedColumn, prefix));
                    continue;
                }
                XmlElementGeneratorTools.generateSelectiveCommColumnTo(trimEle, introspectedColumn, prefix, type);
            }
            return Arrays.asList(trimEle);
        }
        StringBuilder sb = new StringBuilder(bracket ? "(" : "");
        Iterator<IntrospectedColumn> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            IntrospectedColumn introspectedColumn = columnIterator.next();
            switch (type) {
                case 3: {
                    List<Element> incrementEles = PluginTools.getHook(IIncrementsPluginHook.class).incrementSetElementGenerated(introspectedColumn, prefix, false);
                    XmlElement incrementEle = PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSet(introspectedColumn, prefix, false);
                    if (incrementEle != null) {
                        if (sb.length() > 0) {
                            list.add((Element)new TextElement(sb.toString()));
                            sb.setLength(0);
                        }
                        list.add((Element)incrementEle);
                        break;
                    }
                    if (!incrementEles.isEmpty()) {
                        if (sb.length() > 0) {
                            list.add((Element)new TextElement(sb.toString()));
                            sb.setLength(0);
                        }
                        list.addAll(incrementEles);
                        break;
                    }
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                    sb.append(" = ");
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 2: {
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 1: {
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                }
            }
            if (columnIterator.hasNext()) {
                sb.append(", ");
            }
            if (type == 1 || type == 2) {
                if (sb.length() <= 80) continue;
                list.add((Element)new TextElement(sb.toString()));
                sb.setLength(0);
                OutputUtilities.xmlIndent((StringBuilder)sb, (int)1);
                continue;
            }
            list.add((Element)new TextElement(sb.toString()));
            sb.setLength(0);
        }
        if (sb.length() > 0 || bracket) {
            list.add((Element)new TextElement(sb.append(bracket ? ")" : "").toString()));
        }
        return list;
    }

    private static XmlElement generateCommColumnsSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        XmlElement trimEle = XmlElementGeneratorTools.generateTrim(bracket);
        for (IntrospectedColumn introspectedColumn : columns) {
            XmlElementGeneratorTools.generateSelectiveToTrimEleTo(trimEle, introspectedColumn, prefix, type);
        }
        return trimEle;
    }

    private static XmlElement generateTrim(boolean bracket) {
        XmlElement trimEle = new XmlElement("trim");
        if (bracket) {
            trimEle.addAttribute(new Attribute("prefix", "("));
            trimEle.addAttribute(new Attribute("suffix", ")"));
            trimEle.addAttribute(new Attribute("suffixOverrides", ","));
        } else {
            trimEle.addAttribute(new Attribute("suffixOverrides", ","));
        }
        return trimEle;
    }

    private static void generateSelectiveToTrimEleTo(XmlElement trimEle, IntrospectedColumn introspectedColumn, String prefix, int type) {
        if (type != 3 && (introspectedColumn.isSequenceColumn() || introspectedColumn.getFullyQualifiedJavaType().isPrimitive())) {
            XmlElementGeneratorTools.generateSelectiveCommColumnTo(trimEle, introspectedColumn, prefix, type);
        } else if (type == 3 && PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedColumn, prefix) != null) {
            trimEle.addElement((Element)PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedColumn, prefix));
        } else {
            XmlElement eleIf = new XmlElement("if");
            eleIf.addAttribute(new Attribute("test", introspectedColumn.getJavaProperty(prefix) + " != null"));
            XmlElementGeneratorTools.generateSelectiveCommColumnTo(eleIf, introspectedColumn, prefix, type);
            trimEle.addElement((Element)eleIf);
        }
    }

    private static void generateSelectiveCommColumnTo(XmlElement element, IntrospectedColumn introspectedColumn, String prefix, int type) {
        switch (type) {
            case 3: {
                List<Element> incrementEles = PluginTools.getHook(IIncrementsPluginHook.class).incrementSetElementGenerated(introspectedColumn, prefix, true);
                if (!incrementEles.isEmpty()) {
                    for (Element ele : incrementEles) {
                        element.addElement(ele);
                    }
                    break;
                }
                element.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                break;
            }
            case 2: {
                element.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                break;
            }
            case 1: {
                element.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + ","));
            }
        }
    }

    public static void generateWhereByPrimaryKeyTo(XmlElement element, List<IntrospectedColumn> primaryKeyColumns) {
        XmlElementGeneratorTools.generateWhereByPrimaryKeyTo(element, primaryKeyColumns, null);
    }

    public static void generateWhereByPrimaryKeyTo(XmlElement element, List<IntrospectedColumn> primaryKeyColumns, String prefix) {
        StringBuilder sb = new StringBuilder();
        boolean and = false;
        for (IntrospectedColumn introspectedColumn : primaryKeyColumns) {
            sb.setLength(0);
            if (and) {
                sb.append("  and ");
            } else {
                sb.append("where ");
                and = true;
            }
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
            element.addElement((Element)new TextElement(sb.toString()));
        }
    }

    private static boolean hasIdentityAndGeneratedAlwaysColumns(List<IntrospectedColumn> columns) {
        for (IntrospectedColumn ic : columns) {
            if (!ic.isGeneratedAlways() && !ic.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public static XmlElement generateResultMapResultElement(String name, IntrospectedColumn introspectedColumn) {
        XmlElement resultElement = new XmlElement(name);
        resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap((IntrospectedColumn)introspectedColumn)));
        resultElement.addAttribute(new Attribute("property", introspectedColumn.getJavaProperty()));
        resultElement.addAttribute(new Attribute("jdbcType", introspectedColumn.getJdbcTypeName()));
        if (StringUtility.stringHasValue((String)introspectedColumn.getTypeHandler())) {
            resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
        }
        return resultElement;
    }

    public static String generateLogicalDeleteColumnValue(IntrospectedColumn logicalDeleteColumn, String value) {
        StringBuilder sb = new StringBuilder();
        if (value == null || "NULL".equalsIgnoreCase(value)) {
            sb.append("NULL");
        } else if (logicalDeleteColumn.isStringColumn()) {
            sb.append("'");
            sb.append(value);
            sb.append("'");
        } else if (logicalDeleteColumn.getFullyQualifiedJavaType().getFullyQualifiedName().equals(Long.class.getName())) {
            sb.append(value.replaceAll("L|l", ""));
        } else if (logicalDeleteColumn.getFullyQualifiedJavaType().getFullyQualifiedName().equals(Float.class.getName())) {
            sb.append(value.replaceAll("F|f", ""));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String getParameterClause(String valueStr, IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("#{");
        sb.append(valueStr);
        sb.append(",jdbcType=");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (StringUtility.stringHasValue((String)introspectedColumn.getTypeHandler())) {
            sb.append(",typeHandler=");
            sb.append(introspectedColumn.getTypeHandler());
        }
        sb.append('}');
        return sb.toString();
    }
}

