/*
 * Decompiled with CFR 0.152.
 */
package com.jd.security.tdeclient;

import com.jd.security.tdeclient.FlushKeyCacheThread;
import com.jd.security.tdeclient.FlushLogThread;
import com.jd.security.tdeclient.TDEClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecretJdClient {
    private static final Logger LOGGER = Logger.getLogger(SecretJdClient.class.getName());
    private static final ConcurrentMap<String, TDEClient> cache = new ConcurrentHashMap<String, TDEClient>();
    private static final long km_epoch = 28800L;
    private static final long mq_epoch = 3600L;
    private static final ScheduledExecutorService secret_scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("jd-sdk-secret-flush-thread");
            t.setDaemon(true);
            return t;
        }
    });
    private static final ScheduledExecutorService mq_scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("jd-sdk-api-report-thread");
            t.setDaemon(true);
            return t;
        }
    });

    private SecretJdClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDEClient getInstance(String serverUrl, String accessToken, String appKey, String appSecret) throws Exception {
        TDEClient tdeClient = (TDEClient)cache.get(accessToken);
        if (tdeClient == null) {
            String string = accessToken.intern();
            synchronized (string) {
                if (cache.get(accessToken) == null) {
                    TDEClient instance = TDEClient.getInstance(serverUrl, accessToken, appKey, appSecret);
                    cache.putIfAbsent(accessToken, instance);
                }
            }
        }
        return (TDEClient)cache.get(accessToken);
    }

    private static void scheduler() {
        secret_scheduler.scheduleAtFixedRate(new FlushKeyCacheThread(), 28800L, 28800L, TimeUnit.SECONDS);
        mq_scheduler.scheduleAtFixedRate(new FlushLogThread(), 3600L, 3600L, TimeUnit.SECONDS);
    }

    public static ConcurrentMap<String, TDEClient> getCache() {
        return cache;
    }

    static {
        SecretJdClient.scheduler();
    }
}

