/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.cache.loader.service;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.cache.loader.vo.CacheLoaderProperties;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class CacheLoaderService {
    private static final Logger logger = LoggerFactory.getLogger(CacheLoaderService.class);
    @Autowired
    CacheLoaderProperties cacheLoaderProperties;
    @Autowired
    JdbcTemplate jdbcTemplate;
    private RedisClient client = null;
    private StatefulRedisConnection<String, String> connection;
    private static final String VALUE_TYPE_STRING = "string";
    private static final String VALUE_TYPE_HASH = "hash";
    private static final String VALUE_TYPE_LIST = "list";
    private static final String LOAD_TYPE_ROW = "row";
    private static final String LOAD_TYPE_TYPE = "type";
    private static final String VALUE_CODER_JSON = "json";

    @PostConstruct
    void init() {
        this.client = RedisClient.create((String)this.cacheLoaderProperties.getRedisUrl());
        this.connection = this.client.connect();
    }

    @PreDestroy
    void destroy() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public void load() {
        logger.warn("\u5f00\u59cb\u52a0\u8f7d\u7f13\u5b58\u914d\u7f6e");
        if (this.cacheLoaderProperties != null && this.cacheLoaderProperties.getConfigs() != null && this.cacheLoaderProperties.getConfigs().length > 0) {
            for (final CacheLoaderProperties.Config config : this.cacheLoaderProperties.getConfigs()) {
                ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(config.getPrefix() + ":" + config.getKeyName()).daemon(true).build());
                pool.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        block24: {
                            try {
                                logger.warn("pool\u5f00\u59cb\u5237\u65b0\u7f13\u5b58\uff1a{}", (Object)config.getDesc());
                                logger.warn("\u5f00\u59cb\u5237\u65b0\u7f13\u5b58\uff1a{}", (Object)config.getDesc());
                                if (config.getLoadType() != null && CacheLoaderService.LOAD_TYPE_ROW.equals(config.getLoadType().trim())) {
                                    if (config.getValueCoder() != null && !CacheLoaderService.VALUE_CODER_JSON.equals(config.getValueCoder())) {
                                        logger.error("ValueCoder \u8981\u4e0d\u4e3a\u7a7a\uff0c\u8981\u4e0d\u4e3ajson \uff0c\u5f53\u524d\u503c \u4e3a\uff1a{}", (Object)config.getValueCoder());
                                        return;
                                    }
                                    List datas = CacheLoaderService.this.jdbcTemplate.queryForList(config.getSql());
                                    if (CacheLoaderService.VALUE_TYPE_STRING.equals(config.getValueType())) {
                                        for (Map data : datas) {
                                            logger.debug("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a{}", (Object)data);
                                            if (data.get(config.getKeyName()) != null) {
                                                String key = data.get(config.getKeyName()).toString();
                                                if (StringUtils.isBlank((CharSequence)config.getPrefix())) {
                                                    CacheLoaderService.this.connection.sync().set((Object)key, (Object)JSON.toJSONString((Object)data));
                                                    continue;
                                                }
                                                CacheLoaderService.this.connection.sync().set((Object)(config.getPrefix() + ":" + key), (Object)JSON.toJSONString((Object)data));
                                                continue;
                                            }
                                            logger.error("key \u503c \u4e3a\u7a7a \uff1a{}", (Object)data);
                                        }
                                        break block24;
                                    }
                                    if (CacheLoaderService.VALUE_TYPE_HASH.equals(config.getValueType())) {
                                        for (Map data : datas) {
                                            logger.debug("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a{}", (Object)data);
                                            if (data.get(config.getKeyName()) != null) {
                                                String key = data.get(config.getKeyName()).toString();
                                                for (Map.Entry stringObjectEntry : data.entrySet()) {
                                                    if (StringUtils.isBlank((CharSequence)config.getPrefix())) {
                                                        CacheLoaderService.this.connection.sync().hset((Object)key, stringObjectEntry.getKey(), (Object)(stringObjectEntry.getValue() != null ? stringObjectEntry.getValue().toString() : ""));
                                                        continue;
                                                    }
                                                    CacheLoaderService.this.connection.sync().hset((Object)(config.getPrefix() + ":" + key), stringObjectEntry.getKey(), (Object)(stringObjectEntry.getValue() != null ? stringObjectEntry.getValue().toString() : ""));
                                                }
                                                continue;
                                            }
                                            logger.error("key \u503c \u4e3a\u7a7a \uff1a{}", (Object)data);
                                        }
                                        break block24;
                                    }
                                    logger.error("\u672a\u77e5 valueType:{}", (Object)config.getValueType());
                                    break block24;
                                }
                                if (config.getLoadType() != null && CacheLoaderService.LOAD_TYPE_TYPE.equals(config.getLoadType().trim())) {
                                    List datas = CacheLoaderService.this.jdbcTemplate.queryForList(config.getSql());
                                    for (Map data : datas) {
                                        logger.debug("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a{}", (Object)data);
                                        if (data.get(config.getKeyName()) != null) {
                                            String key = null;
                                            key = config.getPrefix() == null || config.getPrefix().trim().equals("") ? data.get(config.getKeyName()).toString() : config.getPrefix() + ":" + data.get(config.getKeyName()).toString();
                                            if (CacheLoaderService.VALUE_TYPE_HASH.equals(config.getValueType())) {
                                                CacheLoaderService.this.connection.sync().hset((Object)key, (Object)data.get("_key").toString(), (Object)JSON.toJSONString((Object)data));
                                                continue;
                                            }
                                            if (CacheLoaderService.VALUE_TYPE_LIST.equals(config.getValueType())) {
                                                logger.warn("\u6d4b\u8bd5REDIS:{}", data.get("key_"));
                                                if (data.get("_value") != null) {
                                                    try {
                                                        CacheLoaderService.this.connection.sync().sadd((Object)key, (Object[])new String[]{data.get("_value").toString()});
                                                    }
                                                    catch (Exception e) {
                                                        logger.error("\u8bbe\u7f6e\u7f13\u5b58\u65f6\u51fa\u9519:{}", (Object)e.getLocalizedMessage(), (Object)e);
                                                        logger.error("\u914d\u7f6e\u4e3a:{}", (Object)config);
                                                        logger.error("\u6570\u636e\u4e3a:{}", (Object)data);
                                                    }
                                                    continue;
                                                }
                                                logger.error("_key or _value \u503c \u4e3a\u7a7a \uff1a{}", (Object)data);
                                                continue;
                                            }
                                            try {
                                                CacheLoaderService.this.connection.sync().hset((Object)key, (Object)data.get("_key").toString(), (Object)data.get("_value").toString());
                                            }
                                            catch (Exception e) {
                                                logger.error("\u8bbe\u7f6e\u7f13\u5b58\u65f6\u51fa\u9519{}", (Object)e.getLocalizedMessage(), (Object)e);
                                                logger.error("\u914d\u7f6e\u4e3a:{}", (Object)config);
                                                logger.error("\u6570\u636e\u4e3a:{}", (Object)data);
                                            }
                                            continue;
                                        }
                                        logger.error("key \u503c \u4e3a\u7a7a \uff1a{}", (Object)data);
                                    }
                                } else {
                                    logger.error("loadType\uff1a{} \u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b", (Object)config.getLoadType());
                                }
                            }
                            catch (Exception e) {
                                logger.error("\u52a0\u8f7d\u7f13\u5b58\u65f6\u51fa\u9519\uff1a{}", (Object)e.getLocalizedMessage(), (Object)e);
                            }
                        }
                    }
                }, 100L, config.getReloadTime(), TimeUnit.MILLISECONDS);
            }
        } else {
            logger.error("\u672a\u914d\u7f6e\u7f13\u5b58");
        }
    }
}

