/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.log.api;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jdaz.sinosoftgz.apis.log.api.SnowFlake;
import java.beans.Transient;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApisLog
implements Serializable {
    private static ThreadLocal<ApisLog> current = new ThreadLocal();
    private static ThreadLocal<Object> requestHolder = new ThreadLocal();
    private static Boolean initFlag = false;
    private static final Logger logger = LoggerFactory.getLogger(ApisLog.class);
    private static String apiLogServerUrl = "";
    private static String appName = "";
    private static String hostName;
    private static ThreadPoolExecutor executor;
    static SnowFlake snowFlake;
    Map<String, Object> dataHadSend = new ConcurrentHashMap<String, Object>();
    Set<String> tagHadSend = new HashSet<String>();
    public static final MediaType JSON;
    public static final OkHttpClient CLIENT;
    private Boolean endFlag = false;
    private ApisLog parent;
    private Long id = snowFlake.nextId();
    private Long parentId;
    private String unionId;
    private Date startTime;
    private Date endTime;
    private String businessNode;
    private Set<String> tags = new HashSet<String>();
    private String content;
    private String level;

    static {
        executor = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("log-app-common-pool-%d").build());
        snowFlake = new SnowFlake(1L, 1L);
        JSON = MediaType.get((String)"application/json; charset=utf-8");
        CLIENT = new OkHttpClient.Builder().connectionPool(new ConnectionPool(2, 60L, TimeUnit.SECONDS)).connectTimeout(10L, TimeUnit.SECONDS).callTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public static void setReqeust(Object request) {
        requestHolder.set(request);
    }

    public static Object getRequest() {
        return requestHolder.get();
    }

    public static void clearRequest() {
        requestHolder.set(null);
    }

    public static void removeRequest() {
        requestHolder.remove();
    }

    public static void clearCurrent() {
        current.remove();
    }

    public static void init(String logServerUrl, String initAppName, String initHostName) {
        apiLogServerUrl = logServerUrl;
        appName = initAppName;
        hostName = initHostName;
        initFlag = true;
        logger.warn("\u6d4b\u8bd5\u8fde\u63a5\u5730\u5740\u6253\u5370log\uff0curl\u4e3a\uff1a{}\uff0cappName\u4e3a\uff1a{}\uff0chostName\u4e3a\uff1a{}", new Object[]{apiLogServerUrl, appName, hostName});
    }

    private ApisLog() {
    }

    public static ApisLog current() {
        return current.get();
    }

    public static ApisLog currentOrMakeNew(String unionId) {
        ApisLog apisLog = current.get();
        if (apisLog != null) {
            return apisLog;
        }
        return ApisLog.create(unionId);
    }

    public static ApisLog create() {
        ApisLog apisLog = new ApisLog();
        apisLog.unionId = "_$_" + apisLog.id;
        apisLog.setAppName(appName);
        ApisLog oldApisLog = current.get();
        if (oldApisLog != null && !oldApisLog.endFlag.booleanValue()) {
            oldApisLog.sendAndEnd();
        }
        current.set(apisLog);
        return apisLog;
    }

    public static ApisLog create(String unionId) {
        ApisLog apisLog = ApisLog.create();
        apisLog.unionId = unionId;
        return apisLog;
    }

    public ApisLog createChild() {
        ApisLog apisLog = new ApisLog();
        apisLog.parentId = this.parentId;
        apisLog.unionId = this.unionId;
        apisLog.parent = this;
        return apisLog;
    }

    public ApisLog send() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        this.sendLog();
        return this;
    }

    public void sendAndEnd() {
        if (this.endTime == null) {
            this.endTime = new Date();
        }
        this.sendLog();
        this.endFlag = true;
        current.set(null);
    }

    public void sendAndEnd(Date endDate) {
        this.endTime = endDate;
        this.sendAndEnd();
    }

    private static boolean post(String json) {
        RequestBody body = RequestBody.create((MediaType)JSON, (byte[])json.getBytes());
        logger.warn("\u6d4b\u8bd5\u8fde\u63a5\u5730\u5740\u6253\u5370log\uff0c\u5f53\u6b21\u8bf7\u6c42url\u4e3a\uff1a{},\u53c2\u6570\u503c\u4e3a\uff1a{}", (Object)apiLogServerUrl, (Object)com.alibaba.fastjson.JSON.toJSONString((Object)body));
        Request request = new Request.Builder().url(apiLogServerUrl).post(body).build();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Response response = CLIENT.newCall(request).execute();){
                boolean bl = response.code() >= 200 && response.code() <= 300;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("\u53d1\u9001\u65e5\u5fd7\u51fa\u9519" + e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private ApisLog sendLog() {
        if (!initFlag.booleanValue()) {
            logger.error("logApi \u672a\u521d\u59cb\u5316");
            return this;
        }
        ApisLog log = this;
        executor.execute(() -> {
            ConcurrentHashMap<String, Object> sendDataMap = new ConcurrentHashMap<String, Object>();
            if (log.getId() != null) {
                sendDataMap.put("id", log.getId());
            }
            if (log.getParentId() != null) {
                sendDataMap.put("parentId", log.getParentId());
            }
            if (log.getBusinessNode() != null) {
                sendDataMap.put("businessNode", log.getBusinessNode());
            }
            if (log.getContent() != null) {
                sendDataMap.put("content", log.getContent());
            }
            if (log.getEndTime() != null) {
                sendDataMap.put("endTime", log.getEndTime());
            }
            if (log.getStartTime() != null) {
                sendDataMap.put("startTime", log.getStartTime());
            }
            if (log.getAppName() != null) {
                sendDataMap.put("appName", log.getAppName());
            }
            if (hostName != null) {
                sendDataMap.put("hostName", hostName);
            }
            if (log.getLevel() != null) {
                sendDataMap.put("level", log.getLevel());
            }
            HashSet<String> tagsMap = new HashSet<String>();
            if (apisLog.tags != null) {
                tagsMap.addAll(log.getTags());
                sendDataMap.put("tags", tagsMap);
            }
            if (log.getUnionId() == null) {
                log.setUnionId("_$_" + log.getId());
            }
            sendDataMap.put("unionId", log.getUnionId());
            for (String key : this.dataHadSend.keySet()) {
                if (!sendDataMap.containsKey(key) || "content".equals(key) || "tags".equals(key) || "businessNode".equals(key)) continue;
                sendDataMap.remove(key);
            }
            for (String key : sendDataMap.keySet()) {
                if ("id".equals(key)) continue;
                if ("tags".equals(key)) {
                    tagsMap.removeAll(this.tagHadSend);
                    this.tagHadSend.addAll(tagsMap);
                    continue;
                }
                if ("content".equals(key)) {
                    String oldContent = "";
                    String newContent = "";
                    if (this.dataHadSend.get("content") instanceof String) {
                        oldContent = (String)this.dataHadSend.get("content");
                    }
                    if (sendDataMap.get("content") instanceof String) {
                        newContent = (String)sendDataMap.get("content");
                    }
                    if (newContent == null) continue;
                    if (!newContent.equals(oldContent)) {
                        this.dataHadSend.put("content", newContent);
                        continue;
                    }
                    sendDataMap.remove("content");
                    continue;
                }
                this.dataHadSend.put(key, sendDataMap.get(key));
            }
            try {
                ApisLog.post(com.alibaba.fastjson.JSON.toJSONString(sendDataMap));
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u65e5\u5fd7\u5230\u65e5\u5fd7\u670d\u52a1\u5668\u65f6\u51fa\u9519" + e.getMessage(), (Throwable)e);
            }
        });
        return this;
    }

    @Transient
    public ApisLog getParent() {
        return this.parent;
    }

    public Long getId() {
        return this.id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public String getLevel() {
        return this.level;
    }

    public ApisLog setLevel(String level) {
        this.level = level;
        return this;
    }

    public String getAppName() {
        return appName;
    }

    public ApisLog setAppName(String appName) {
        ApisLog.appName = appName;
        return this;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public ApisLog setUnionId(String unionId) {
        this.unionId = unionId;
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ApisLog setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ApisLog setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getBusinessNode() {
        return this.businessNode;
    }

    public ApisLog setBusinessNode(String businessNode) {
        this.businessNode = businessNode;
        return this;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public ApisLog setTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public ApisLog addTag(String ... tag) {
        if (tag != null && tag.length > 0) {
            String[] stringArray = tag;
            int n = tag.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.tags.add(s);
                ++n2;
            }
        }
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public ApisLog setContent(String content) {
        this.content = content;
        return this;
    }

    public static void shutdown() {
        executor.shutdown();
    }
}

