/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.log;

import cn.hutool.core.io.IoUtil;
import com.jdaz.sinosoftgz.apis.log.ApisLogClientConfigProperties;
import com.jdaz.sinosoftgz.apis.log.ApisLogRequestWrapper;
import com.jdaz.sinosoftgz.apis.log.ApisLogResponseWrapper;
import com.jdaz.sinosoftgz.apis.log.api.ApisLog;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@ConditionalOnClass(value={Filter.class})
@WebFilter(urlPatterns={"/*"})
public class ApisLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ApisLogFilter.class);
    @Autowired
    ApisLogClientConfigProperties apisLogClientConfigProperties;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.warn("=======================ApisLogFilter \u5f00\u59cb\u521d\u59cb\u5316=========================");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block23: {
            Date startDate = new Date();
            ApisLogRequestWrapper apisLogRequestWrapper = null;
            ApisLogResponseWrapper apisLogResponseWrapper = null;
            Boolean errorFlag = false;
            String errorMessage = null;
            if (this.apisLogClientConfigProperties.getEnableLogFilter().booleanValue()) {
                HttpServletRequest request;
                String uid = null;
                try {
                    request = null;
                    if (servletRequest instanceof HttpServletRequest) {
                        request = (HttpServletRequest)servletRequest;
                    }
                    String string = uid = request.getHeader("business-no") == null ? request.getHeader("transaction-no") : request.getHeader("business-no");
                    if (uid == null || "".equals(uid.trim())) {
                        uid = request.getHeader("request-hash");
                    }
                    ApisLog.setReqeust((Object)uid);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                try {
                    try {
                        request = null;
                        if (servletRequest instanceof HttpServletRequest) {
                            request = (HttpServletRequest)servletRequest;
                        }
                        HttpServletResponse response = null;
                        if (servletResponse instanceof HttpServletResponse) {
                            response = (HttpServletResponse)servletResponse;
                        }
                        apisLogRequestWrapper = new ApisLogRequestWrapper(request);
                        apisLogResponseWrapper = new ApisLogResponseWrapper(response);
                        filterChain.doFilter((ServletRequest)apisLogRequestWrapper, (ServletResponse)apisLogResponseWrapper);
                        servletResponse.getOutputStream().write(apisLogResponseWrapper.getBytes());
                        break block23;
                    }
                    catch (Exception e) {
                        logger.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519:", (Throwable)e);
                        errorFlag = true;
                        errorMessage = e.getMessage();
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    block25: {
                        logger.warn("\u8bf7\u6c42url\uff1a{},\u603b\u7528\u65f6 :{}", (Object)((HttpServletRequest)servletRequest).getRequestURI(), (Object)(System.currentTimeMillis() - startDate.getTime()));
                        try {
                            try {
                                byte[] requestBodyBytes = new byte[]{};
                                if (apisLogRequestWrapper != null) {
                                    requestBodyBytes = IoUtil.readBytes((InputStream)apisLogRequestWrapper.getInputStream());
                                }
                                byte[] responseBodyBytes = new byte[]{};
                                if (apisLogResponseWrapper != null) {
                                    responseBodyBytes = apisLogResponseWrapper.getBytes();
                                }
                                ApisLog.create((String)uid).setContent(new String(requestBodyBytes, StandardCharsets.UTF_8)).setBusinessNode("api:in").setStartTime(startDate).setLevel("info").sendAndEnd();
                                ApisLog.create((String)uid).setContent(new String(responseBodyBytes, StandardCharsets.UTF_8)).setBusinessNode("api:out").setStartTime(new Date()).setLevel("info").sendAndEnd();
                                if (errorFlag.booleanValue()) {
                                    ApisLog.create((String)uid).setContent(errorMessage).setBusinessNode("api:out").setStartTime(new Date()).setLevel("error").sendAndEnd();
                                }
                            }
                            catch (Exception e) {
                                logger.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
                                ApisLog.clearRequest();
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            ApisLog.clearRequest();
                            throw throwable;
                        }
                        ApisLog.clearRequest();
                    }
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

