/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.config;

import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
public class FreeMarkerConfig
implements InitializingBean,
ServletContextAware {
    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;
    @Value(value="${context.projectstatic:layuimini}")
    private String projectStaticPath;
    @Value(value="${context.ctx:}")
    private String dynaContentPath;
    @Autowired
    ResourceUrlProvider resourceUrlProvider;
    ServletContext servletContext;

    public void afterPropertiesSet() throws Exception {
        freemarker.template.Configuration configuration = this.freeMarkerConfigurer.getConfiguration();
        String projectContextPath = this.servletContext.getContextPath();
        configuration.setSharedVariable("static", (Object)this.projectStaticPath);
        if (StringUtils.isEmpty((Object)this.projectStaticPath)) {
            configuration.setSharedVariable("static", (Object)projectContextPath);
        }
        configuration.setSharedVariable("ctx", (Object)this.dynaContentPath);
        if (StringUtils.isEmpty((Object)this.dynaContentPath)) {
            configuration.setSharedVariable("ctx", (Object)projectContextPath);
        }
        configuration.setNumberFormat("#");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

