/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.config;

import com.jdaz.sinosoftgz.apis.adminapp.config.ClassPathTldsLoader;
import com.jdaz.sinosoftgz.apis.adminapp.platform.common.cas.CasProperties;
import com.jdaz.sinosoftgz.apis.adminapp.platform.common.cas.CustomUserDetailsServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisPermissionsMenuServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisRoleServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisUserServiceImpl;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    ServerProperties serverProperties;
    @Autowired
    CasProperties casProperties;
    @Autowired
    private ApisUserServiceImpl apisUserService;
    @Autowired
    private ApisRoleServiceImpl apisRoleService;
    @Autowired
    private ApisPermissionsMenuServiceImpl apisPermissionsMenuService;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        super.configure(auth);
        auth.authenticationProvider((AuthenticationProvider)this.casAuthenticationProvider());
    }

    @Bean
    public CasAuthenticationEntryPoint casAuthenticationEntryPoint() {
        CasAuthenticationEntryPoint casAuthenticationEntryPoint = new CasAuthenticationEntryPoint();
        casAuthenticationEntryPoint.setLoginUrl(this.casProperties.getCasServerLoginUrl());
        casAuthenticationEntryPoint.setServiceProperties(this.serviceProperties());
        return casAuthenticationEntryPoint;
    }

    @Bean
    public ServiceProperties serviceProperties() {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(this.casProperties.getAppServerUrl() + this.casProperties.getAppLoginUrl());
        return serviceProperties;
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter() throws Exception {
        CasAuthenticationFilter casAuthenticationFilter = new CasAuthenticationFilter();
        casAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        casAuthenticationFilter.setFilterProcessesUrl(this.casProperties.getAppLoginUrl());
        return casAuthenticationFilter;
    }

    @Bean
    public CasAuthenticationProvider casAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setAuthenticationUserDetailsService(this.customUserDetailsService());
        casAuthenticationProvider.setServiceProperties(this.serviceProperties());
        casAuthenticationProvider.setTicketValidator((TicketValidator)this.cas20ServiceTicketValidator());
        casAuthenticationProvider.setKey("casAuthenticationProviderKey");
        return casAuthenticationProvider;
    }

    @Bean
    public AuthenticationUserDetailsService<CasAssertionAuthenticationToken> customUserDetailsService() {
        return new CustomUserDetailsServiceImpl(this.apisUserService, this.apisRoleService, this.apisPermissionsMenuService);
    }

    @Bean
    public Cas20ServiceTicketValidator cas20ServiceTicketValidator() {
        return new Cas20ServiceTicketValidator(this.casProperties.getCasServerUrl());
    }

    @Bean
    public SingleSignOutFilter singleSignOutFilter() {
        SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
        singleSignOutFilter.setCasServerUrlPrefix(this.casProperties.getCasServerUrl());
        singleSignOutFilter.setIgnoreInitConfiguration(true);
        return singleSignOutFilter;
    }

    @Bean
    public LogoutFilter casLogoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter(this.casProperties.getCasServerLogoutUrl(), new LogoutHandler[]{new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl(this.casProperties.getAppLogoutUrl());
        return logoutFilter;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/layuimini/**"})).permitAll().antMatchers(new String[]{"/subAccount/interface/**"})).permitAll().antMatchers(new String[]{"/IG_ePolicy/IG_eLink/payment/**"})).permitAll().anyRequest()).authenticated().and()).logout().permitAll().and()).formLogin().loginPage("/login").defaultSuccessUrl("/")).and()).rememberMe().and();
        ((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.casAuthenticationEntryPoint()).and()).addFilter((Filter)this.casAuthenticationFilter()).addFilterBefore((Filter)this.casLogoutFilter(), LogoutFilter.class).addFilterBefore((Filter)this.singleSignOutFilter(), CasAuthenticationFilter.class);
        http.headers().frameOptions().sameOrigin();
        http.csrf().disable();
    }

    @Bean
    @ConditionalOnMissingBean(value={ClassPathTldsLoader.class})
    public ClassPathTldsLoader classPathTldsLoader() {
        return new ClassPathTldsLoader(new String[0]);
    }
}

