/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
public class SessionConfig {
    @Autowired
    ServerProperties serverProperties;

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.serverProperties.getServlet().getSession().getCookie().getName());
        serializer.setCookiePath(this.serverProperties.getServlet().getSession().getCookie().getPath());
        serializer.setDomainName(this.serverProperties.getServlet().getSession().getCookie().getDomain());
        if (this.serverProperties.getServlet().getSession().getCookie().getSecure() != null) {
            serializer.setUseSecureCookie(this.serverProperties.getServlet().getSession().getCookie().getSecure().booleanValue());
        }
        serializer.setDomainNamePattern("^.+?\\.(\\w+\\.[a-z]+)$");
        return serializer;
    }
}

