/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller;

import com.jdaz.sinosoftgz.apis.adminapp.utils.Slowlog;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"debug"})
public class DebugController {
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @RequestMapping(value={"redis"})
    @ResponseBody
    public Object redis(@RequestParam(value="str") String str, @RequestParam(value="args") String[] args) {
        byte[][] bytes = new byte[args.length][];
        int i = 0;
        for (String arg : args) {
            bytes[i] = arg != null ? arg.getBytes() : "".getBytes();
            ++i;
        }
        return this.redisTemplate.getConnectionFactory().getConnection().execute(str, (byte[][])bytes);
    }

    @RequestMapping(value={"redis/slowlog"})
    @ResponseBody
    public Object slowlog() throws ExecutionException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Properties info = this.redisTemplate.getConnectionFactory().getConnection().serverCommands().info();
        map.put("info", info);
        Object conn = this.redisTemplate.getConnectionFactory().getConnection().getNativeConnection();
        if (conn instanceof RedisAsyncCommands) {
            RedisFuture redisFuture = ((RedisAsyncCommands)conn).slowlogGet(100);
            List result = ((List)redisFuture.get()).stream().map(e -> Slowlog.from((Object)e)).collect(Collectors.toList());
            map.put("slowlog", result);
        }
        return map;
    }

    @RequestMapping(value={"sql"})
    @ResponseBody
    public Object sql(@RequestParam(value="sql") String sql) {
        return this.jdbcTemplate.queryForMap(sql);
    }
}

