/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.system.SystemUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IndexController {
    private static final Logger logger = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    ServerProperties serverProperties;
    String gitInfo;
    String systemInfo;

    @RequestMapping
    public String index() {
        return "index";
    }

    @RequestMapping(value={"welcome"})
    public String welcome(Map parms) {
        String javaVersion = System.getProperty("java.version");
        if (this.gitInfo == null) {
            try {
                this.gitInfo = IoUtil.read((InputStream)IndexController.class.getResourceAsStream("git.properties"), (String)"utf-8");
            }
            catch (Exception e) {
                this.gitInfo = "\u672a\u627e\u5230git.properties";
            }
        }
        parms.put("pid", SystemUtil.getCurrentPID());
        parms.put("date", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd hh:mm:ss"));
        parms.put("thread", SystemUtil.getTotalThreadCount());
        parms.put("mem", (SystemUtil.getTotalMemory() - SystemUtil.getFreeMemory()) / 1024L / 1024L + "/" + SystemUtil.getTotalMemory() / 1024L / 1024L);
        parms.put("gitInfo", this.gitInfo);
        parms.put("java_version", javaVersion);
        parms.put("_port", this.serverProperties.getPort());
        if (this.systemInfo == null) {
            StringWriter stringWriter = new StringWriter();
            SystemUtil.dumpSystemInfo((PrintWriter)new PrintWriter(stringWriter));
            this.systemInfo = stringWriter.toString();
        }
        parms.put("systemInfo", this.systemInfo);
        return "welcome";
    }
}

