/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.cache.row;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.cache.vo.CacheVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.ApisCachePage;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.RedisDataVO;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisCache;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisCacheService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cache"})
public class CacheController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Autowired
    private ApisCacheService apisCacheService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;

    @RequestMapping(value={"/channelUserUri/index"})
    public String indexChannelUserUri() {
        return "cache/channelUserUri/index";
    }

    @RequestMapping(value={"/channelUserUri"})
    @ResponseBody
    public Object pageByHash(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:user:uri");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelCode/index"})
    public String indexChannelCode() {
        return "cache/channelCode/index";
    }

    @RequestMapping(value={"/channelCode"})
    @ResponseBody
    public Object pagechannelCode(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:code");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRoleApi/index"})
    public String indexChannelRoleApi() {
        return "cache/channelRoleApi/index";
    }

    @RequestMapping(value={"/channelRoleApi"})
    @ResponseBody
    public Object pagechannelPoleApi(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:role:api");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRoleApiLimit/index"})
    public String indexChannelRoleApiLimit() {
        return "cache/channelRoleApiLimit/index";
    }

    @RequestMapping(value={"/channelRoleApiLimit"})
    @ResponseBody
    public Object pagechannelRoleApiLimit(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:role:api:limit");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRoleProduct/index"})
    public String indexChannelRoleProduct() {
        return "cache/channelRoleProduct/index";
    }

    @RequestMapping(value={"/channelRoleProduct"})
    @ResponseBody
    public Object pagechannelRoleProduct(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:role:product");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRoute/index"})
    public String indexChannelRoute() {
        return "cache/channelRoute/index";
    }

    @RequestMapping(value={"/channelRoute"})
    @ResponseBody
    public Object pagechannelRole(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:route");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRouteBusinessType/index"})
    public String indexRouteBusinessTyp() {
        return "cache/channelRouteBusinessType/index";
    }

    @RequestMapping(value={"/channelRouteBusinesstype"})
    @ResponseBody
    public Object pagechannelRoleBusinessType(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:route:businesstype");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelRouteBusinessType/toEdit"})
    public String channelRouteBusinessTypeEdit(String key, String value, Map map) {
        logger.warn("to Edit page.key={}, value={}", (Object)key, (Object)value);
        RedisDataVO channelRouteBusinessTypeRedis = RedisDataVO.builder().key(key).value(value).build();
        map.put("channelRouteBusinessTypeRedis", channelRouteBusinessTypeRedis);
        return "cache/channelRouteBusinessType/edit";
    }

    @RequestMapping(value={"/channelRouteBusinessType/delete"})
    @ResponseBody
    public Object channelRouteBusinessTypeDelete(String key, String value) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        try {
            logger.warn("delete channel route businessType: key={}, value={}", (Object)key, (Object)value);
            boolean isSucc = this.iApisChannelUserService.redisSetRemove(key, value);
            if (!isSucc) {
                ajaxResultVo.setCode(Integer.valueOf(1));
                ajaxResultVo.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"/channelRouteBusinessType/updRedisData"})
    @ResponseBody
    public Object channelRouteBusinessTypeUpdate(String key, String value, String originKey, String originValue) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        logger.warn("update channel route businessType: key={}, value={}, originKey={}, originValue={}", new Object[]{key, value, originKey, originValue});
        if (!StringUtils.equals((CharSequence)value, (CharSequence)originValue)) {
            this.iApisChannelUserService.redisSetUpdate(originKey, originValue, key, value);
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"/channelRoutemain/index"})
    public String indexChannelRoutemain() {
        return "cache/channelRoutemain/index";
    }

    @RequestMapping(value={"/channelRoutemain"})
    @ResponseBody
    public Object pagechannelRoteMain(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:routemain");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelUser/index"})
    public String indexChannelUser() {
        return "cache/channelUser/index";
    }

    @RequestMapping(value={"/channelUser"})
    @ResponseBody
    public Object pageChannelUser(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:user");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"/channelCodeBusinessType/index"})
    public String index10() {
        return "cache/channelCodeBusinessType/index";
    }

    @RequestMapping(value={"/channelCodeBusinessType"})
    @ResponseBody
    public Object pagechannelUserUri(PageVo pageVo, CacheVo cacheVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        cacheVo.setPrefix("channel:code:businesstype");
        if (!"".equals(cacheVo.getTextName()) && cacheVo.getTextName() != null) {
            return this.iApisChannelUserService.searchByRedis(page, cacheVo);
        }
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchByDate(page, cacheVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"page"})
    public String getCachePage() {
        return "cache/index";
    }

    @RequestMapping(value={"/getCachePage"})
    @ResponseBody
    public Object getCacheData(PageVo pageVo, ApisCachePage apisCachePage) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelUserService.getRedis(page, apisCachePage);
        return pageResultVo1;
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("apisCache", new ApisCache());
        return "cache/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisCache apisCache = (ApisCache)this.apisCacheService.getById((Serializable)id);
        map.put("apisCache", apisCache);
        return "cache/addOrEdit";
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisCache apisCache) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)apisCache);
        try {
            Integer.valueOf(apisCache.getReloadTime());
        }
        catch (Exception e) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(e.getMessage());
            return ajaxResultVo;
        }
        try {
            if (apisCache.getId() == null) {
                apisCache.setCreateTime(new Date());
                this.apisCacheService.save((Object)apisCache);
            } else {
                apisCache.setUpdateTime(new Date());
                this.apisCacheService.updateById((Object)apisCache);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)apisCache), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }
}

