/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.api.ChannelApiQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelApi;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisChannelApiHistService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelApiService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/api"})
public class ChannelApiController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelApiController.class);
    @Autowired
    IApisChannelApiService iApisChannelApiService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;
    @Autowired
    ApisChannelApiHistService apisChannelApiHistService;

    @RequestMapping(value={"index"})
    public String index() {
        return "channel/api/index";
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("channelApi", new ApisChannelApi());
        this.fillAddOrEditData(map);
        return "channel/api/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelApi channelApi = (ApisChannelApi)this.iApisChannelApiService.getById((Serializable)id);
        map.put("channelApi", channelApi);
        this.fillAddOrEditData(map);
        return "channel/api/addOrEdit";
    }

    private void fillAddOrEditData(Map map) {
        map.put("userList", this.iApisChannelUserService.list());
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisChannelApi channelApi, HttpServletRequest request) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelApi);
        try {
            this.iApisChannelApiService.preEditValidate(channelApi);
            if (channelApi.getId() == null) {
                channelApi.setCreateTime(new Date());
                channelApi.setCreator(request.getRemoteUser());
                this.iApisChannelApiService.save((Object)channelApi);
                this.apisChannelApiHistService.saveAddOrUpdateHist(channelApi, request.getRemoteUser(), "A");
            } else {
                this.apisChannelApiHistService.saveAddOrUpdateHist(channelApi, request.getRemoteUser(), "C");
                channelApi.setModifier(request.getRemoteUser());
                channelApi.setUpdateTime(new Date());
                this.iApisChannelApiService.updateById((Object)channelApi);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelApi), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id, HttpServletRequest request) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(String.valueOf(id));
        this.apisChannelApiHistService.saveDeleteHist(ids, request.getRemoteUser());
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.iApisChannelApiService.removeById((Serializable)id);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelApiQueryVo channelApiQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelApiService.searchBy(page, channelApiQueryVo);
        return pageResultVo1;
    }
}

