/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.code;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.code.ChannelCodeQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisChannelCodeHistService;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisSystemDataDictService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/code"})
public class ChannelCodeController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelCodeController.class);
    @Autowired
    IApisChannelCodeService iApisChannelCodeService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;
    @Autowired
    ApisSystemDataDictService apisSystemDataDictService;
    @Autowired
    ApisChannelCodeHistService apisChannelCodeHistService;

    @RequestMapping(value={"index"})
    public String index(Map map) {
        this.loadDataDict(map);
        return "channel/code/index";
    }

    public void loadDataDict(Map map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dict_type", (Object)"2");
        List apisSystemDataDictList = this.apisSystemDataDictService.list((Wrapper)queryWrapper);
        map.put("apisSystemDataDictList", apisSystemDataDictList);
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("channelCode", new ApisChannelCode());
        this.fillAddOrEditData(map);
        this.loadDataDict(map);
        return "channel/code/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelCode channelCode = (ApisChannelCode)this.iApisChannelCodeService.getById((Serializable)id);
        this.fillAddOrEditData(map);
        map.put("channelCode", channelCode);
        this.loadDataDict(map);
        return "channel/code/addOrEdit";
    }

    private void fillAddOrEditData(Map map) {
        map.put("userList", this.iApisChannelUserService.list());
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisChannelCode channelCode, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelCode);
        try {
            if (channelCode.getId() == null) {
                channelCode.setCreateTime(new Date());
                channelCode.setCreator(httpServletRequest.getRemoteUser());
                this.iApisChannelCodeService.save((Object)channelCode);
                this.apisChannelCodeHistService.saveAddOrUpdateHist(channelCode, httpServletRequest.getRemoteUser(), "A");
            } else {
                this.apisChannelCodeHistService.saveAddOrUpdateHist(channelCode, httpServletRequest.getRemoteUser(), "C");
                channelCode.setModifier(httpServletRequest.getRemoteUser());
                channelCode.setUpdateTime(new Date());
                this.iApisChannelCodeService.updateById((Object)channelCode);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelCode), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id, HttpServletRequest httpServletRequest) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(String.valueOf(id));
        this.apisChannelCodeHistService.saveDeleteHist(ids, httpServletRequest.getRemoteUser());
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.iApisChannelCodeService.removeById((Serializable)id);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelCodeQueryVo channelCodeQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelCodeService.searchBy(page, channelCodeQueryVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"deleteAll"})
    @ResponseBody
    public Object allDelete(@RequestParam String test2, HttpServletRequest httpServletRequest) {
        List<String> longList = Arrays.asList(test2.split(","));
        this.apisChannelCodeHistService.saveDeleteHist(longList, httpServletRequest.getRemoteUser());
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        Boolean bean = this.iApisChannelCodeService.removeByIds(longList);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f" + bean);
        return ajaxResultVo;
    }
}

