/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.company;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.company.ChannelCompanyQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelCompany;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelCompanyService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/company"})
public class ChannelCompanyController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelCompanyController.class);
    @Autowired
    IApisChannelCompanyService iApisChannelCompanyService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;

    @RequestMapping(value={"index"})
    public String index() {
        return "channel/company/index";
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("channelCompany", new ApisChannelCompany());
        this.fillAddOrEdit(map);
        return "channel/company/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelCompany channelCompany = (ApisChannelCompany)this.iApisChannelCompanyService.getById((Serializable)id);
        map.put("channelCompany", channelCompany);
        this.fillAddOrEdit(map);
        return "channel/company/addOrEdit";
    }

    private void fillAddOrEdit(Map map) {
        map.put("userList", this.iApisChannelUserService.list());
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisChannelCompany channelCompany) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelCompany);
        try {
            this.iApisChannelCompanyService.preEditValidate(channelCompany);
            if (channelCompany.getId() == null) {
                this.iApisChannelCompanyService.save((Object)channelCompany);
            } else {
                this.iApisChannelCompanyService.updateById((Object)channelCompany);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelCompany), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.iApisChannelCompanyService.removeById((Serializable)id);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelCompanyQueryVo channelCompanyQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelCompanyService.searchBy(page, channelCompanyQueryVo);
        return pageResultVo1;
    }
}

