/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.configs;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.configs.ChannelConfigsQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisChannelConfigsHistService;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisSystemDataDictService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/configs"})
public class ChannelConfigController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelConfigController.class);
    @Autowired
    IApisChannelConfigsService iApisChannelConfigsService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;
    @Autowired
    IApisChannelCodeService iApisChannelCodeService;
    @Autowired
    ApisSystemDataDictService apisSystemDataDictService;
    @Autowired
    ApisChannelConfigsHistService apisChannelConfigsHistService;

    @RequestMapping(value={"index"})
    public String index(Map map) {
        this.loadDataDict(map);
        return "channel/configs/index";
    }

    public void loadDataDict(Map map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dict_type", (Object)"1");
        List apisSystemDataDictList = this.apisSystemDataDictService.list((Wrapper)queryWrapper);
        map.put("apisSystemDataDictList", apisSystemDataDictList);
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("channelConfigs", new ApisChannelConfigs());
        this.fillAddOrEditData(map);
        this.loadDataDict(map);
        return "channel/configs/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelConfigs channelConfigs = (ApisChannelConfigs)this.iApisChannelConfigsService.getById((Serializable)id);
        map.put("channelConfigs", channelConfigs);
        this.fillAddOrEditData(map);
        this.loadDataDict(map);
        return "channel/configs/addOrEdit";
    }

    private void fillAddOrEditData(Map map) {
        map.put("userList", this.iApisChannelUserService.list());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)"riskType");
        map.put("productList", this.iApisChannelCodeService.list((Wrapper)queryWrapper));
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisChannelConfigs channelConfigs, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelConfigs);
        String user = httpServletRequest.getRemoteUser();
        ArrayList<ApisChannelConfigs> histList = new ArrayList<ApisChannelConfigs>();
        try {
            if (channelConfigs.getId() == null) {
                channelConfigs.setCreator(user);
                channelConfigs.setCreateTime(new Date());
                this.iApisChannelConfigsService.save((Object)channelConfigs);
                histList.add(channelConfigs);
                this.apisChannelConfigsHistService.saveBachApisChannelConfigs(histList, user, "A");
            } else {
                histList.add(channelConfigs);
                this.apisChannelConfigsHistService.saveBachApisChannelConfigs(histList, user, "C");
                channelConfigs.setModifier(user);
                channelConfigs.setUpdateTime(new Date());
                this.iApisChannelConfigsService.updateById((Object)channelConfigs);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelConfigs), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id, HttpServletRequest httpServletRequest) {
        String user = httpServletRequest.getRemoteUser();
        ArrayList<String> longList = new ArrayList<String>();
        longList.add(String.valueOf(id));
        this.apisChannelConfigsHistService.saveDeleteApisChannelConfigsHist(longList, user);
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.iApisChannelConfigsService.removeById((Serializable)id);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelConfigsQueryVo channelConfigsQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelConfigsService.searchBy(page, channelConfigsQueryVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"deleteAll"})
    @ResponseBody
    public Object allDelete(@RequestParam String test2, HttpServletRequest httpServletRequest) {
        String user = httpServletRequest.getRemoteUser();
        List<String> longList = Arrays.asList(test2.split(","));
        this.apisChannelConfigsHistService.saveDeleteApisChannelConfigsHist(longList, user);
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        Boolean bean = this.iApisChannelConfigsService.deleteApisChannelConfigsByIds(longList);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f" + bean);
        return ajaxResultVo;
    }
}

