/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.product;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.product.ChannelProductQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelProduct;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisChannelProductHistService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelProductService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/product"})
public class ChannelProductController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelProductController.class);
    @Autowired
    IApisChannelProductService iApisChannelProductService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;
    @Autowired
    ApisChannelProductHistService apisChannelProductHistService;

    @RequestMapping(value={"index"})
    public String index() {
        return "channel/product/index";
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        map.put("channelProduct", new ApisChannelProduct());
        this.fillAddOrEditData(map);
        return "channel/product/add";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelProduct channelProduct = (ApisChannelProduct)this.iApisChannelProductService.getById((Serializable)id);
        map.put("channelProduct", channelProduct);
        this.fillAddOrEditData(map);
        return "channel/product/edit";
    }

    private void fillAddOrEditData(Map map) {
        map.put("userList", this.iApisChannelUserService.list());
    }

    @RequestMapping(value={"doAdd"})
    @ResponseBody
    public Object doAdd(ApisChannelProduct channelProduct, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelProduct);
        try {
            this.iApisChannelProductService.preEditValidate(channelProduct);
            HashSet<ApisChannelProduct> apisChannelProducts = new HashSet<ApisChannelProduct>();
            List<String> planList = Arrays.asList(channelProduct.getPlanCode().split(","));
            List<String> productList = Arrays.asList(channelProduct.getProductCode().split(","));
            if (productList.size() == planList.size()) {
                for (int i = 0; i < productList.size(); ++i) {
                    ApisChannelProduct apisChannelProduct = new ApisChannelProduct();
                    apisChannelProduct.setProductCode(productList.get(i));
                    apisChannelProduct.setPlanCode(planList.get(i));
                    apisChannelProduct.setChannelCode(channelProduct.getChannelCode());
                    apisChannelProduct.setValidFlag(channelProduct.getValidFlag());
                    apisChannelProduct.setUserCode(channelProduct.getUserCode());
                    apisChannelProduct.setCreateTime(new Date());
                    apisChannelProduct.setCreator(httpServletRequest.getRemoteUser());
                    apisChannelProducts.add(apisChannelProduct);
                }
                this.iApisChannelProductService.saveBatch(apisChannelProducts);
                this.apisChannelProductHistService.saveBachApisChannelProduct(new ArrayList(apisChannelProducts), httpServletRequest.getRemoteUser(), "A");
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelProduct), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"doEdit"})
    @ResponseBody
    public Object doEdit(ApisChannelProduct channelProduct, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelProduct);
        try {
            this.iApisChannelProductService.preEditValidate(channelProduct);
            if (Objects.nonNull(channelProduct.getId())) {
                ArrayList<ApisChannelProduct> apisChannelProducts = new ArrayList<ApisChannelProduct>();
                apisChannelProducts.add(channelProduct);
                this.apisChannelProductHistService.saveBachApisChannelProduct(apisChannelProducts, httpServletRequest.getRemoteUser(), "C");
                channelProduct.setModifier(httpServletRequest.getRemoteUser());
                channelProduct.setUpdateTime(new Date());
                this.iApisChannelProductService.updateById((Object)channelProduct);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelProduct), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id, HttpServletRequest request) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(String.valueOf(id));
        this.apisChannelProductHistService.saveBachApisChannelProductById(ids, request.getRemoteUser(), "D");
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.iApisChannelProductService.removeById((Serializable)id);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelProductQueryVo channelProductQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelProductService.searchBy(page, channelProductQueryVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"deleteAll"})
    @ResponseBody
    public Object allDelete(@RequestParam String test2, HttpServletRequest request) {
        List<String> longList = Arrays.asList(test2.split(","));
        this.apisChannelProductHistService.saveBachApisChannelProductById(longList, request.getRemoteUser(), "D");
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        Boolean bean = this.iApisChannelProductService.removeByIds(longList);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f" + bean);
        return ajaxResultVo;
    }
}

