/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.user;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.user.ChannelUserQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelUserHist;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisChannelUserHistService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelApiService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelCompanyService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelProductService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import com.jdaz.sinosoftgz.apis.adminapp.utils.DesEncodeUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/user"})
public class ChannelUserController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUserController.class);
    @Autowired
    IApisChannelUserService iApisChannelUserService;
    @Autowired
    IApisChannelProductService apisChannelProductService;
    @Autowired
    IApisChannelApiService apisChannelApiService;
    @Autowired
    IApisChannelCompanyService apisChannelCompanyService;
    @Autowired
    ApisChannelUserHistService apisChannelUserHistService;

    @RequestMapping(value={"index"})
    public String index() {
        return "channel/user/index";
    }

    @RequestMapping(value={"add"})
    public String add(Map map) {
        ApisChannelUser channelUser = new ApisChannelUser();
        String today = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " 00:00:00";
        channelUser.setEffectiveDate((Date)DateUtil.parseDate((CharSequence)today));
        channelUser.setExpireDate((Date)DateUtil.offsetDay((Date)channelUser.getEffectiveDate(), (int)this.getYearDays(channelUser.getEffectiveDate())));
        map.put("channelUser", channelUser);
        return "channel/user/addOrEdit";
    }

    public int getYearDays(Date date) {
        int year = DateUtil.year((Date)date);
        int month = DateUtil.month((Date)date);
        if (month < 3 && DateUtil.isLeapYear((int)year)) {
            return 366;
        }
        return 365;
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map map) {
        ApisChannelUser channelUser = (ApisChannelUser)this.iApisChannelUserService.getById((Serializable)id);
        if (ObjectUtil.isNotEmpty((Object)channelUser) && ObjectUtil.isNotEmpty((Object)channelUser.getPwd())) {
            try {
                channelUser.setEncryptPwd(DesEncodeUtil.getDesString((String)channelUser.getPwd()));
            }
            catch (Exception e) {
                logger.error("setEncryptPwd error: ", (Throwable)e);
            }
        }
        map.put("channelUser", channelUser);
        return "channel/user/addOrEdit";
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisChannelUser channelUser, HttpServletRequest httpServletRequest) {
        String user = httpServletRequest.getRemoteUser();
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)channelUser);
        try {
            this.iApisChannelUserService.checkUserCode(channelUser);
            if (StringUtils.isEmpty((CharSequence)channelUser.getJfeeStepFlag())) {
                channelUser.setJfeeStepFlag("2");
            }
            if (channelUser.getId() == null) {
                this.iApisChannelUserService.checkUserCode(channelUser);
                channelUser.setCreator(user);
                channelUser.setCreateTime(new Date());
                this.iApisChannelUserService.save((Object)channelUser);
                ApisChannelUserHist apisChannelUserHist = new ApisChannelUserHist();
                BeanUtils.copyProperties((Object)channelUser, (Object)apisChannelUserHist);
                apisChannelUserHist.setId(null);
                apisChannelUserHist.setHistActionCode("A");
                apisChannelUserHist.setHistCreator(user);
                this.apisChannelUserHistService.save((Object)apisChannelUserHist);
            } else {
                channelUser.setModifier(user);
                channelUser.setUpdateTime(new Date());
                this.apisChannelUserHistService.updateApisChannelUser(String.valueOf(channelUser.getId()), user);
                this.iApisChannelUserService.updateById((Object)channelUser);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6e20\u9053\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)channelUser), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ApisChannelUser channelUser = (ApisChannelUser)this.iApisChannelUserService.getById((Serializable)id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user_Code", channelUser.getUserCode());
        ApisChannelUserHist apisChannelUserHist = new ApisChannelUserHist();
        BeanUtils.copyProperties((Object)channelUser, (Object)apisChannelUserHist);
        apisChannelUserHist.setId(null);
        apisChannelUserHist.setHistActionCode("D");
        apisChannelUserHist.setHistCreator(httpServletRequest.getRemoteUser());
        this.apisChannelUserHistService.save((Object)apisChannelUserHist);
        this.iApisChannelUserService.removeById((Serializable)id);
        this.apisChannelProductService.removeByMap(map);
        this.apisChannelApiService.removeByMap(map);
        this.apisChannelCompanyService.removeByMap(map);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        return ajaxResultVo;
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, ChannelUserQueryVo channelUserQueryVo) {
        this.handerQueryDate(channelUserQueryVo);
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisChannelUserService.searchBy(page, channelUserQueryVo);
        return pageResultVo1;
    }

    private void handerQueryDate(ChannelUserQueryVo channelUserQueryVo) {
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getStartDate())) {
            String startDate = DateUtil.format((Date)DateUtil.parse((CharSequence)channelUserQueryVo.getStartDate().split("-")[0].replace(" ", ""), (String)"yyyyMMddHHmmss"), (String)"yyyy-MM-dd HH:mm:ss");
            String endDate = DateUtil.format((Date)DateUtil.parse((CharSequence)channelUserQueryVo.getStartDate().split("-")[1].replace(" ", ""), (String)"yyyyMMddHHmmss"), (String)"yyyy-MM-dd HH:mm:ss");
            channelUserQueryVo.setStartDate(startDate);
            channelUserQueryVo.setEndDate(endDate);
        }
    }

    @RequestMapping(value={"deleteAll"})
    @ResponseBody
    public Object allDelete(@RequestParam String test2, HttpServletRequest httpServletRequest) {
        List<String> longList = Arrays.asList(test2.split(","));
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        this.apisChannelUserHistService.deleteAllApisChannelUser(longList, httpServletRequest.getRemoteUser());
        Boolean bean = this.iApisChannelUserService.removeByIds(longList);
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f" + bean);
        return ajaxResultVo;
    }

    @RequestMapping(value={"countUser"})
    @ResponseBody
    public Object countUser(ChannelUserQueryVo channelUserQueryVo) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        int count = (Integer)this.getDownLoadUsers(channelUserQueryVo, true).get("count");
        if (count == 0) {
            ajaxResultVo.setCode(Integer.valueOf(0));
        } else {
            ajaxResultVo.setCode(Integer.valueOf(1));
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"downLoad"})
    public void excelDownLoad(ChannelUserQueryVo channelUserQueryVo, HttpServletResponse response) {
        ExcelWriter writer = ExcelUtil.getWriter();
        List channelUsers = (List)this.getDownLoadUsers(channelUserQueryVo, false).get("resultList");
        writer.writeCellValue(0, 0, (Object)"\u51fa\u5355\u8d26\u53f7");
        writer.writeCellValue(1, 0, (Object)"\u51fa\u5355\u8d26\u6237\u540d");
        writer.writeCellValue(2, 0, (Object)"\u6e20\u9053\u4ee3\u7801");
        writer.writeCellValue(3, 0, (Object)"\u6e20\u9053\u540d\u79f0");
        writer.writeCellValue(4, 0, (Object)"\u5bc6\u7801");
        writer.writeCellValue(5, 0, (Object)"\u673a\u6784\u4ee3\u7801");
        writer.writeCellValue(6, 0, (Object)"\u5f52\u5c5e\u4e1a\u52a1\u5458");
        for (int i = 0; i < channelUsers.size(); ++i) {
            ApisChannelUser user = (ApisChannelUser)channelUsers.get(i);
            writer.writeCellValue(0, i + 1, (Object)user.getUserCode());
            writer.writeCellValue(1, i + 1, (Object)user.getUserName());
            writer.writeCellValue(2, i + 1, (Object)user.getChannelCode());
            writer.writeCellValue(3, i + 1, (Object)user.getChannelName());
            writer.writeCellValue(4, i + 1, (Object)user.getPwd());
            writer.writeCellValue(5, i + 1, (Object)user.getComCode());
            writer.writeCellValue(6, i + 1, (Object)user.getHandlerCode());
        }
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=user.xls");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.flush((OutputStream)out, true);
        writer.close();
        IoUtil.close((Closeable)out);
    }

    private Map getDownLoadUsers(ChannelUserQueryVo channelUserQueryVo, boolean countFlag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.handerQueryDate(channelUserQueryVo);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getChannelCode())) {
            queryWrapper.eq((Object)"channel_code", (Object)channelUserQueryVo.getChannelCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getChannelName())) {
            queryWrapper.like((Object)"channel_name", (Object)channelUserQueryVo.getChannelName());
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getUserCode())) {
            queryWrapper.eq((Object)"user_code", (Object)channelUserQueryVo.getUserCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getUserName())) {
            queryWrapper.like((Object)"user_name", (Object)channelUserQueryVo.getUserName());
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getStartDate()) && StringUtils.isEmpty((CharSequence)channelUserQueryVo.getEndDate())) {
            queryWrapper.apply("DATE_FORMAT(create_time,'%Y-%m-%d %H %i %s')>={0}", new Object[]{channelUserQueryVo.getStartDate()});
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getEndDate()) && StringUtils.isEmpty((CharSequence)channelUserQueryVo.getStartDate())) {
            queryWrapper.apply("DATE_FORMAT(create_time,'%Y-%m-%d %H %i %s')<={0}", new Object[]{channelUserQueryVo.getEndDate()});
        }
        if (StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getStartDate()) && StringUtils.isNotEmpty((CharSequence)channelUserQueryVo.getEndDate())) {
            queryWrapper.apply("DATE_FORMAT(create_time,'%Y-%m-%d %H %i %s')>={0} and DATE_FORMAT(create_time,'%Y-%m-%d %H %i %s')<={1}", new Object[]{channelUserQueryVo.getStartDate(), channelUserQueryVo.getEndDate()});
        }
        if (countFlag) {
            map.put("count", this.iApisChannelUserService.count((Wrapper)queryWrapper));
        } else {
            map.put("resultList", this.iApisChannelUserService.list((Wrapper)queryWrapper));
        }
        return map;
    }

    @RequestMapping(value={"getPublicKey"})
    @ResponseBody
    public Object toPush(String secretKey) {
        return DesEncodeUtil.getEncString((String)secretKey);
    }
}

