/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.channel.warn;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.warn.WarnConfigQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisBusiWarnRule;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisBusiWarnRuleService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"channel/warn"})
public class WarnConfigController {
    private static final Logger log = LoggerFactory.getLogger(WarnConfigController.class);
    @Autowired
    IApisBusiWarnRuleService iApisBusiWarnRuleService;
    @Autowired
    IApisChannelCodeService iApisChannelCodeService;
    @Autowired
    IApisChannelUserService iApisChannelUserService;

    @RequestMapping(value={"index"})
    public String index() {
        return "channel/warn/index";
    }

    @RequestMapping(value={"add"})
    public String add(Map<String, Object> map) {
        this.fillAddOrEditData(null, map);
        return "channel/warn/addOrEdit";
    }

    @RequestMapping(value={"edit"})
    public String edit(Long id, Map<String, Object> map) {
        this.fillAddOrEditData(id, map);
        return "channel/warn/addOrEdit";
    }

    private void fillAddOrEditData(Long id, Map<String, Object> map) {
        if (id != null) {
            ApisBusiWarnRule warnConfig = (ApisBusiWarnRule)this.iApisBusiWarnRuleService.getById((Serializable)id);
            map.put("warnConfigs", warnConfig);
        } else {
            map.put("warnConfigs", new ApisBusiWarnRule());
        }
        map.put("userList", this.iApisChannelUserService.list());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)"riskType");
        map.put("productList", this.iApisChannelCodeService.list((Wrapper)queryWrapper));
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, WarnConfigQueryVo vo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        return this.iApisBusiWarnRuleService.searchBy(page, vo);
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisBusiWarnRule apisBusiWarnRule, HttpServletRequest httpServletRequest) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)apisBusiWarnRule);
        String user = httpServletRequest.getRemoteUser();
        try {
            if (apisBusiWarnRule.getId() == null) {
                apisBusiWarnRule.setCreator(user);
                apisBusiWarnRule.setCreateTime(new Date());
                this.iApisBusiWarnRuleService.save((Object)apisBusiWarnRule);
            } else {
                apisBusiWarnRule.setModifier(user);
                apisBusiWarnRule.setUpdateTime(new Date());
                this.iApisBusiWarnRuleService.updateById((Object)apisBusiWarnRule);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u914d\u7f6e\u544a\u8b66\u4fe1\u606f\u5f02\u5e38 channelConfigs:{}", (Object)JSONObject.toJSONString((Object)apisBusiWarnRule), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(Long id) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        try {
            if (this.iApisBusiWarnRuleService.removeById((Serializable)id)) {
                ajaxResultVo.setCode(Integer.valueOf(0));
                ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
            } else {
                ajaxResultVo.setCode(Integer.valueOf(1));
                ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u914d\u7f6e\u544a\u8b66\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 id:{}", (Object)id, (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"deleteAll"})
    @ResponseBody
    public Object allDelete(@RequestParam String ids) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        try {
            List<String> idList = Arrays.asList(ids.split(","));
            if (this.iApisBusiWarnRuleService.removeByIds(idList)) {
                ajaxResultVo.setCode(Integer.valueOf(0));
                ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
            } else {
                ajaxResultVo.setCode(Integer.valueOf(1));
                ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u914d\u7f6e\u544a\u8b66\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 ids:{}", (Object)JSONObject.toJSONString((Object)ids), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }
}

