/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.menu;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.adminapp.controller.menu.MenuResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisPermissionsMenu;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisPermissionsMenuService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"menu"})
public class MenuController {
    private static final Logger logger = LoggerFactory.getLogger(MenuController.class);
    @Autowired
    IApisPermissionsMenuService apisPermissionsMenuService;

    @RequestMapping(value={"index"})
    public String index() {
        return "menu/index";
    }

    @RequestMapping(value={"loadMenu"})
    @ResponseBody
    public Object loadMenu() {
        MenuResultVo menuResultVo = new MenuResultVo();
        menuResultVo.setCode(Integer.valueOf(0));
        menuResultVo.setMsg("ok");
        List list = this.apisPermissionsMenuService.findMenus();
        JSONArray array = new JSONArray();
        for (ApisPermissionsMenu apisPermissionsMenu : list) {
            JSONObject object = new JSONObject();
            object.put("id", (Object)apisPermissionsMenu.getId());
            object.put("name", (Object)apisPermissionsMenu.getName());
            object.put("url", (Object)(StringUtils.isNotEmpty((CharSequence)apisPermissionsMenu.getUrl()) ? apisPermissionsMenu.getUrl() : ""));
            object.put("parentId", ObjectUtil.isNotEmpty((Object)apisPermissionsMenu.getParentId()) ? apisPermissionsMenu.getParentId() : "0");
            object.put("idx", (Object)apisPermissionsMenu.getShowIdx());
            array.add((Object)object);
        }
        menuResultVo.setData((List)array);
        menuResultVo.setCount(Integer.valueOf(list.size()));
        return menuResultVo;
    }

    @RequestMapping(value={"addOrEditPage"})
    public String addOrEditPage(String id, String parentId, Map map) {
        ApisPermissionsMenu apisPermissionsMenu = new ApisPermissionsMenu();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            apisPermissionsMenu = (ApisPermissionsMenu)this.apisPermissionsMenuService.getById((Serializable)((Object)id));
        }
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            apisPermissionsMenu.setParentId(new Long(parentId));
        }
        map.put("model", apisPermissionsMenu);
        return "menu/addOrEdit";
    }

    @RequestMapping(value={"doAddOrEdit"})
    @ResponseBody
    public Object doAddOrEdit(ApisPermissionsMenu apisPermissionsMenu) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
        ajaxResultVo.setData((Object)apisPermissionsMenu);
        try {
            if (apisPermissionsMenu.getId() == null) {
                this.apisPermissionsMenuService.save((Object)apisPermissionsMenu);
            } else {
                this.apisPermissionsMenuService.updateById((Object)apisPermissionsMenu);
            }
        }
        catch (ValidateException ve) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg(ve.getMessage());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u83dc\u5355\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 apisSystemDataDict:{}", (Object)JSONObject.toJSONString((Object)apisPermissionsMenu), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public Object delete(String id) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        try {
            this.apisPermissionsMenuService.deleteObjectById(id);
            ajaxResultVo.setCode(Integer.valueOf(0));
            ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxResultVo;
    }
}

