/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.product.ration;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.product.ration.RationQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisPfpRationClauseKindFactory;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisPfsInsuredType;
import com.jdaz.sinosoftgz.apis.adminapp.service.ApisPfsInsuredTypeService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisPfpRationClauseKindFactoryService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisPfpRationKindService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ApisDataDictionaryConstants;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"product/ration"})
public class RationController {
    private static final Logger log = LoggerFactory.getLogger(RationController.class);
    @Autowired
    private IApisPfpRationMainService iApisPfpRationMainService;
    @Autowired
    IApisPfpRationKindService iApisPfpRationKindService;
    @Autowired
    IApisPfpRationClauseKindFactoryService iApisPfpRationClauseKindFactoryService;
    @Autowired
    ApisPfsInsuredTypeService apisPfsInsuredTypeService;

    @RequestMapping(value={"index"})
    public String index() {
        return "product/ration/index";
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public Object page(PageVo pageVo, RationQueryVo rationQueryVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo1 = this.iApisPfpRationMainService.searchBy(page, rationQueryVo);
        return pageResultVo1;
    }

    @RequestMapping(value={"toDetail"})
    public String toDetail(Long id, Map map) {
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setId(id);
        this.writebackApisPfpRationMain(apisPfpRationMain);
        map.put("apisPfpRationMain", apisPfpRationMain);
        return "product/ration/detail";
    }

    @RequestMapping(value={"toBaseInfo"})
    public String toBaseInfo(Long id, Map map) {
        ApisPfpRationMain apisPfpRationMain = (ApisPfpRationMain)this.iApisPfpRationMainService.getById((Serializable)id);
        this.writebackApisPfpRationMain(apisPfpRationMain);
        map.put("apisPfpRationMain", apisPfpRationMain);
        return "product/ration/baseInfo";
    }

    @RequestMapping(value={"toItemKind"})
    public String toItemKind(Long id, Map map) {
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setId(id);
        map.put("apisPfpRationMain", apisPfpRationMain);
        return "product/ration/itemkind";
    }

    @RequestMapping(value={"itemKindPage"})
    @ResponseBody
    public Object itemKindPage(PageVo pageVo, ApisPfpRationMain rationMain) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = this.iApisPfpRationKindService.getApisPfpRationKindList(page, rationMain.getId().longValue());
        return pageResultVo;
    }

    @RequestMapping(value={"toBaofeiPeizhi"})
    public String toBaofeiPeizhi(Long id, Map map) {
        try {
            ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
            apisPfpRationMain.setId(id);
            map.put("apisPfpRationMain", apisPfpRationMain);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4fdd\u8d39\u8ba1\u7b97\u914d\u9519\u51fa\u9519\uff1a", (Throwable)e);
        }
        return "product/ration/baoFeiPeiZhi";
    }

    @RequestMapping(value={"baoFeiPeiZhiPage"})
    @ResponseBody
    public Object baoFeiPeiZhiPage(PageVo pageVo, ApisPfpRationMain rationMain) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = this.iApisPfpRationClauseKindFactoryService.getClauseKindFactoryList(page, rationMain.getId().longValue());
        if (ObjectUtil.isNotEmpty((Object)pageResultVo.getData()) && pageResultVo.getData().size() > 0) {
            this.writebackclauseKindFactory(pageResultVo.getData());
        }
        return pageResultVo;
    }

    private void writebackclauseKindFactory(List<ApisPfpRationClauseKindFactory> clauseKindFactoryList) {
        for (ApisPfpRationClauseKindFactory kindFactory : clauseKindFactoryList) {
            if (StringUtils.isNotEmpty((CharSequence)kindFactory.getGdInsuredType()) && StringUtils.isNotEmpty((CharSequence)this.getInsuredTypeName(kindFactory.getGdInsuredType()))) {
                kindFactory.setGdInsuredType(kindFactory.getGdInsuredType() + "-(" + this.getInsuredTypeName(kindFactory.getGdInsuredType()) + ")");
            }
            kindFactory.setGdPremiumConfig(ApisDataDictionaryConstants.premiumConfigMap.get(kindFactory.getGdPremiumConfig()).toString());
        }
    }

    private String getInsuredTypeName(String insuredType) {
        if (StringUtils.isNotEmpty((CharSequence)insuredType)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"insured_type", (Object)insuredType);
            ApisPfsInsuredType apisPfsInsuredType = (ApisPfsInsuredType)this.apisPfsInsuredTypeService.getOne((Wrapper)queryWrapper, false);
            if (ObjectUtil.isNotEmpty((Object)apisPfsInsuredType)) {
                return apisPfsInsuredType.getInsuredName();
            }
            return "";
        }
        return "";
    }

    public void writebackApisPfpRationMain(ApisPfpRationMain apisPfpRationMain) {
        int i;
        String[] arr;
        String str;
        if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getClassCode())) {
            apisPfpRationMain.setClassCode(ApisDataDictionaryConstants.classCodeMap.get(apisPfpRationMain.getClassCode()).toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAppliRelation())) {
            str = "";
            arr = apisPfpRationMain.getAppliRelation().split(",");
            for (i = 0; i < arr.length; ++i) {
                str = str + ApisDataDictionaryConstants.appliRelationMap.get(arr[i]) + ",";
            }
            apisPfpRationMain.setAppliRelation(str.substring(0, str.length() - 1));
        }
        if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation())) {
            str = "";
            arr = apisPfpRationMain.getInsuredOccupation().split(",");
            for (i = 0; i < arr.length; ++i) {
                str = str + ApisDataDictionaryConstants.occupationTypeMap.get(arr[i]) + ",";
            }
            apisPfpRationMain.setInsuredOccupation(str.substring(0, str.length() - 1));
        }
        if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getPaymentType())) {
            str = "";
            arr = apisPfpRationMain.getPaymentType().split(",");
            for (i = 0; i < arr.length; ++i) {
                str = str + ApisDataDictionaryConstants.paymentTypeMap.get(arr[i]) + ",";
            }
            apisPfpRationMain.setPaymentType(str.substring(0, str.length() - 1));
        }
    }
}

