/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.rolePermissions;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.ChildDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.HomePageDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.MenuInfoDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.page.RoleDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.page.UserManagePageDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.ApisRolePermissionsVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisRole;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisUser;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisUserRoleLinks;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisRolePremsLinksService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisRoleService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisUserRoleLinksService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisUserService;
import com.jdaz.sinosoftgz.apis.adminapp.utils.OkHttpUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/rolePerm"})
@Controller
public class RolePermissionsController {
    private static Logger logger = LoggerFactory.getLogger(RolePermissionsController.class);
    @Autowired
    private IApisUserService apisUserService;
    @Autowired
    private IApisRoleService apisRoleService;
    @Autowired
    private IApisUserRoleLinksService apisUserRoleLinksService;
    @Autowired
    private IApisRolePremsLinksService apisRolePremsLinksService;
    @Value(value="${cas.server.host.userInterfaceURL}")
    private String ssoAddress;

    @RequestMapping(value={"/init"})
    @ResponseBody
    public Object init(HttpServletResponse response) throws Exception {
        String currentUserName = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            throw new Exception("\u65e0\u6743\u9650");
        }
        currentUserName = authentication.getName();
        HomePageDTO homePageDTO = new HomePageDTO();
        MenuInfoDTO menuInfoDTO = new MenuInfoDTO();
        if ("admin".equals(currentUserName)) {
            List childDTOList = this.returnMenu(currentUserName, Integer.valueOf(1), null, new ArrayList(), "all");
            menuInfoDTO.setChildDTOList(childDTOList);
        } else {
            List childDTOList = this.returnMenu(currentUserName, Integer.valueOf(1), null, new ArrayList(), null);
            menuInfoDTO.setChildDTOList(childDTOList);
        }
        homePageDTO.setMenuInfoDTO(menuInfoDTO);
        return homePageDTO;
    }

    private List<ChildDTO> returnMenu(String currentUserName, Integer permMenuType, String permParentId, List<ChildDTO> childDTO_list, String type) {
        if (childDTO_list == null) {
            childDTO_list = new ArrayList<ChildDTO>();
        }
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("userCode", currentUserName);
        parmMap.put("permMenuType", permMenuType);
        parmMap.put("permParentId", permParentId);
        List rolePermVoList = new ArrayList();
        rolePermVoList = type != null && type.equals("all") ? this.apisUserService.getRolePermissionsAdminByList(parmMap) : this.apisUserService.getRolePermissionsByList(parmMap);
        if (rolePermVoList.size() == 0) {
            return null;
        }
        for (ApisRolePermissionsVO temp : rolePermVoList) {
            ChildDTO child = new ChildDTO();
            child.setTitle(temp.getPermName());
            child.setIcon(temp.getPermIcon());
            child.setHref(temp.getPermUrl());
            child.setTarget(temp.getPermTarget());
            childDTO_list.add(child);
            List childDTO_list2 = this.returnMenu(currentUserName, Integer.valueOf(2), temp.getPermId(), null, type);
            if (childDTO_list2 == null) continue;
            child.setChildDTOList(childDTO_list2);
        }
        return childDTO_list;
    }

    @RequestMapping(value={"/userManage"})
    public String userManage() {
        return "userPermissions/user/userManage";
    }

    @RequestMapping(value={"/addUser"})
    public String addUser() {
        return "userPermissions/user/addUserWindow";
    }

    @RequestMapping(value={"/saveUser"})
    @ResponseBody
    public Map saveUser(String userCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 1);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f");
        try {
            String url = this.ssoAddress + "/sys/sysuser/_selectOneByUserCode?userCode=" + userCode;
            String response = OkHttpUtils.getJson((String)url);
            JSONObject responseJson = JSONObject.parseObject((String)response);
            if (responseJson.get((Object)"message").equals("Success")) {
                if (responseJson.getJSONObject("data") == null) {
                    throw new Exception("\u7528\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
                }
            } else {
                throw new Exception("\u8bf7\u6c42\u5355\u70b9\u7cfb\u7edf\u8d25");
            }
            this.apisUserService.saveUser(responseJson.getJSONObject("data"));
        }
        catch (Exception e) {
            map.put("code", 0);
            map.put("msg", "\u65b0\u589e\u5931\u8d25\uff01" + e.getMessage());
        }
        return map;
    }

    @RequestMapping(value={"/userManagePage"})
    @ResponseBody
    public Object userManagePage(PageVo pageVo, UserManagePageDTO userManagePageDTO) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = null;
        try {
            pageResultVo = this.apisUserService.selectByUserManageQueryDTO(page, userManagePageDTO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageResultVo;
    }

    @RequestMapping(value={"/showUserDetail"})
    public String showUserInfo(String userId, Map map) {
        ApisUser userDetail = this.apisUserService.getUserDetail(userId);
        map.put("userDetail", userDetail);
        return "userPermissions/user/userDetailWindow";
    }

    @RequestMapping(value={"/viewUserRole"})
    public String viewUserRole(String userId, String roleId, Map map) {
        HashMap queryMap = new HashMap();
        List roleList = this.apisRoleService.getList(queryMap);
        map.put("role_list", roleList);
        map.put("userId", userId);
        map.put("oldRoleId", "null".equals(roleId) ? "" : roleId);
        return "userPermissions/user/userRoleWindow";
    }

    @RequestMapping(value={"/setupRole"}, method={RequestMethod.POST})
    @ResponseBody
    public Object setupRole(ApisUserRoleLinks apisUserRoleLinks) throws Exception {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        try {
            if (apisUserRoleLinks.getUserId() != null) {
                this.apisUserRoleLinksService.updateRoleByUserId(apisUserRoleLinks);
            }
            ajaxResultVo.setCode(Integer.valueOf(0));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u6210\u529f");
            ajaxResultVo.setData((Object)apisUserRoleLinks);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5931\u8d25\uff1a", (Object)JSONObject.toJSONString((Object)apisUserRoleLinks), (Object)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"/permissionsManage"})
    public String permissionsManage() {
        return "userPermissions/permissions/permissionsManage";
    }

    @RequestMapping(value={"/permissionsManagePage"})
    @ResponseBody
    public Object permissionsManagePage(PageVo pageVo, ApisRole apisRole) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = null;
        try {
            pageResultVo = this.apisRoleService.selectByRoleManageQueryDTO(page, apisRole);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageResultVo;
    }

    @RequestMapping(value={"/addRole"})
    public String addRole(String id, Map map) {
        ApisRole role = (ApisRole)this.apisRoleService.getById((Serializable)((Object)id));
        map.put("role", role);
        return "userPermissions/permissions/addRoleWindow";
    }

    @RequestMapping(value={"/getRoleTree"})
    @ResponseBody
    public List<Map<String, Object>> getRoleTree() {
        ArrayList<Map<String, Object>> roleTreeList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> allTitle = new HashMap<String, Object>();
        try {
            allTitle.put("title", "\u5168\u90e8");
            allTitle.put("checked", false);
            allTitle.put("spread", true);
            allTitle.put("children", this.apisRoleService.getAllRoleTree());
            roleTreeList.add(allTitle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roleTreeList;
    }

    @RequestMapping(value={"/saveRole"})
    @ResponseBody
    public Map save(@RequestBody RoleDTO roleDTO) {
        Map<String, String> map = new HashMap<String, Integer>();
        try {
            map = this.apisRoleService.saveRoles(roleDTO);
        }
        catch (Exception e) {
            map.put("code", (String)((Object)Integer.valueOf(0)));
            map.put("msg", "\u7f16\u8f91\u89d2\u8272\u5931\u8d25\uff01" + e.getMessage());
        }
        return map;
    }

    @RequestMapping(value={"/delUser"})
    @ResponseBody
    public Object deleteUser(String userId, Map map) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        try {
            ApisUser userDetail = this.apisUserService.getUserDetail(userId);
            userDetail.setDeleteFlag(Integer.valueOf(1));
            userDetail.setValidFlag(Integer.valueOf(0));
            this.apisUserService.updateById((Object)userDetail);
            ajaxResultVo.setCode(Integer.valueOf(0));
            ajaxResultVo.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7528\u6237\u5931\u8d25\uff1a", (Throwable)e);
            ajaxResultVo.setCode(Integer.valueOf(1));
            ajaxResultVo.setMsg("\u5220\u9664\u7528\u6237\u5931\u8d25:{}" + e.getMessage());
        }
        return ajaxResultVo;
    }

    @RequestMapping(value={"/findPerm"})
    @ResponseBody
    public List<String> findPerm(HttpServletResponse response, String id) {
        ArrayList<String> son = new ArrayList<String>();
        son.addAll(this.apisRolePremsLinksService.queryAllRolePermsLink(id));
        response.setContentType("text/json");
        return son;
    }
}

