/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.controller.subAccount;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.AjaxResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.BDInfoQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.BitchSubVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.ProductDetailVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.SubAccountVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.SubAddVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.SubDetailVO;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisBusiAppLog;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisBusiAppLogService;
import com.jdaz.sinosoftgz.apis.adminapp.service.SubAccountService;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisChannelProductServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisChannelUserServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.QueryAgentInfoRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.QueryProductsInfoRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.SyncProductRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.UpdateChannelDataRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.body.RequestBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.head.RequestHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.AgentListResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.InterfaceSyncResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.ProductsInfoResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.head.ResponseHead;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subAccount"})
public class SubAccountController {
    private static final Logger logger = LoggerFactory.getLogger(SubAccountController.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private ApisChannelProductServiceImpl apisChannelProductService;
    @Autowired
    private ApisChannelUserServiceImpl apisChannelUserService;
    @Autowired
    private IApisBusiAppLogService apisBusiAppLogService;

    @RequestMapping(value={"index"})
    public String index() {
        return "subAccount/index";
    }

    @RequestMapping(value={"page"})
    @ResponseBody
    public PageResultVo page(PageVo pageVo, SubAccountVO subAccountVO) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = this.subAccountService.page(page, subAccountVO);
        return pageResultVo;
    }

    @ResponseBody
    @PostMapping(value={"getChannelList"})
    public Map<String, Object> getChannelList(HttpServletRequest request) {
        String userCode = "admin";
        QueryAgentInfoRequest queryAgentInfoRequest = QueryAgentInfoRequest.builder().head(new RequestHead()).body(RequestBody.builder().userCode(userCode).build()).build();
        logger.warn("\u6e20\u9053\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)queryAgentInfoRequest));
        AgentListResponse agentListResponse = this.subAccountService.queryAgentList(queryAgentInfoRequest);
        logger.warn("\u6e20\u9053\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)agentListResponse));
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("message", "\u6210\u529f");
        result.put("code", "1");
        result.put("data", agentListResponse.getBody());
        return result;
    }

    @ResponseBody
    @PostMapping(value={"/interface/synchronousProduct"})
    public InterfaceSyncResponse synchronousProduct(@org.springframework.web.bind.annotation.RequestBody SyncProductRequest request) {
        InterfaceSyncResponse interfaceSyncResponse = new InterfaceSyncResponse();
        ResponseHead responseHead = new ResponseHead();
        ApisBusiAppLog apisBusiAppLog = new ApisBusiAppLog();
        apisBusiAppLog.setId(Long.valueOf(System.currentTimeMillis()));
        apisBusiAppLog.setLogContent(JSON.toJSONString((Object)request));
        apisBusiAppLog.setProcCode("api-synchronousProduct:in");
        this.apisBusiAppLogService.save((Object)apisBusiAppLog);
        try {
            this.apisChannelProductService.synchronousProduct(request);
            responseHead.setAppCode("0000");
            responseHead.setAppMessage("\u6210\u529f");
        }
        catch (Exception e) {
            responseHead.setAppCode("-1");
            responseHead.setAppMessage("\u5931\u8d25:" + e.getMessage());
        }
        apisBusiAppLog.setId(Long.valueOf(System.currentTimeMillis()));
        apisBusiAppLog.setLogContent(JSON.toJSONString((Object)responseHead));
        apisBusiAppLog.setProcCode("api-synchronousProduct:out");
        this.apisBusiAppLogService.save((Object)apisBusiAppLog);
        interfaceSyncResponse.setHead(responseHead);
        return interfaceSyncResponse;
    }

    @ResponseBody
    @PostMapping(value={"/interface/updateChannelData"})
    public InterfaceSyncResponse updateChannelData(@org.springframework.web.bind.annotation.RequestBody UpdateChannelDataRequest updateChannelDataRequest, HttpServletRequest request) {
        InterfaceSyncResponse interfaceSyncResponse = new InterfaceSyncResponse();
        ResponseHead responseHead = new ResponseHead();
        ApisBusiAppLog apisBusiAppLog = new ApisBusiAppLog();
        apisBusiAppLog.setId(Long.valueOf(System.currentTimeMillis()));
        apisBusiAppLog.setLogContent(JSON.toJSONString((Object)updateChannelDataRequest));
        apisBusiAppLog.setProcCode("api-updateChannelData:in");
        this.apisBusiAppLogService.save((Object)apisBusiAppLog);
        try {
            this.apisChannelUserService.updateChannelData(updateChannelDataRequest, request.getRemoteUser());
            responseHead.setAppCode("0000");
            responseHead.setAppMessage("\u6210\u529f");
        }
        catch (Exception e) {
            responseHead.setAppCode("-1");
            responseHead.setAppMessage("\u5931\u8d25:" + e.getMessage());
        }
        apisBusiAppLog.setId(Long.valueOf(System.currentTimeMillis()));
        apisBusiAppLog.setLogContent(JSON.toJSONString((Object)responseHead));
        apisBusiAppLog.setProcCode("api-updateChannelData:out");
        this.apisBusiAppLogService.save((Object)apisBusiAppLog);
        interfaceSyncResponse.setHead(responseHead);
        return interfaceSyncResponse;
    }

    @RequestMapping(value={"bdInfo"})
    public String bdInfo() {
        return "subAccount/bdInfoIndex";
    }

    @ResponseBody
    @RequestMapping(value={"bdInfo/page"})
    public PageResultVo bdInfoPage(PageVo pageVo, BDInfoQueryVo bdInfoQueryVo, HttpServletRequest request) {
        String userCode = request.getRemoteUser();
        PageResultVo pageResultVo = this.subAccountService.bdInfoPage(pageVo, bdInfoQueryVo, userCode);
        return pageResultVo;
    }

    @RequestMapping(value={"detail"})
    public String deatil(String userCode, Map map) {
        SubDetailVO subDetailVO = this.subAccountService.queryDetail(userCode);
        map.put("message", "\u6210\u529f");
        map.put("code", "1");
        map.put("subDetailVO", subDetailVO);
        return "subAccount/detail";
    }

    @RequestMapping(value={"channelProducts"})
    @ResponseBody
    public Object channelProducts(PageVo pageVo) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = this.subAccountService.productsPage(page, pageVo.getIstrue());
        return pageResultVo;
    }

    @RequestMapping(value={"detailProducts"})
    @ResponseBody
    public Object detailProducts(PageVo pageVo, String userCode) {
        Page page = new Page((long)pageVo.getPage().intValue(), (long)pageVo.getLimit().intValue());
        PageResultVo pageResultVo = this.subAccountService.productsPage(page, userCode);
        return pageResultVo;
    }

    @RequestMapping(value={"toAdd"})
    public String toAdd(HttpServletRequest request, String agentCode, Map map) {
        String userCode = request.getRemoteUser();
        logger.warn("\u521b\u5efa\u8005\uff1a{}", (Object)userCode);
        QueryAgentInfoRequest queryAgentInfoRequest = QueryAgentInfoRequest.builder().head(new RequestHead()).body(RequestBody.builder().userCode(userCode).agentCode(agentCode).build()).build();
        SubAddVO subAddVO = this.subAccountService.toAdd(queryAgentInfoRequest);
        map.put("message", "\u6210\u529f");
        map.put("code", "1");
        map.put("subAddVO", subAddVO);
        return "subAccount/addOrEdit";
    }

    @RequestMapping(value={"doAdd"})
    @ResponseBody
    public Object doAddOrEdit(SubAddVO subAddVO, HttpServletRequest request) {
        String userCode = request.getRemoteUser();
        logger.warn("\u521b\u5efa\u8005\uff1a{}", (Object)userCode);
        String result = "";
        try {
            result = this.subAccountService.doAdd(subAddVO, userCode);
        }
        catch (Exception e) {
            logger.error("\u589e\u52a0\u5b50\u8d26\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            result = "\u65b0\u589e\u8d26\u53f7\u5f02\u5e38\uff01";
        }
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(result);
        logger.warn("\u589e\u52a0\u5b50\u8d26\u53f7\u5b8c\u6210\uff01");
        return ajaxResultVo;
    }

    @RequestMapping(value={"toAuthorization"})
    public String toAuthorization(String userCode, Map map) {
        SubDetailVO subDetailVO = this.subAccountService.queryDetail(userCode);
        map.put("message", "\u6210\u529f");
        map.put("code", "1");
        map.put("subDetailVO", subDetailVO);
        return "subAccount/authorization";
    }

    @RequestMapping(value={"doUpdate"})
    @ResponseBody
    public Object doUpdate(SubDetailVO subDetailVO, HttpServletRequest request) {
        String result = this.subAccountService.doUpdate(subDetailVO, request.getRemoteUser());
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(result);
        return ajaxResultVo;
    }

    @RequestMapping(value={"doAuthorization"})
    @ResponseBody
    public Object doAuthorization(String data) {
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("");
        return ajaxResultVo;
    }

    @RequestMapping(value={"toGetProducts"})
    public String getProducts(String agentCode, String userCode, HttpServletRequest request, Map map) {
        String user = request.getRemoteUser();
        QueryProductsInfoRequest queryProductsInfoRequest = QueryProductsInfoRequest.builder().head(new RequestHead()).body(RequestBody.builder().agentCode(agentCode).userCode(user).build()).build();
        map.put("message", "\u6210\u529f");
        map.put("code", "1");
        map.put("agentCode", agentCode);
        map.put("userCode", userCode);
        return "subAccount/chooseProduct";
    }

    @RequestMapping(value={"doGetProducts"})
    @ResponseBody
    public Object doGetProducts(String agentCode, String userCode, String isDelete, HttpServletRequest request) {
        String user = request.getRemoteUser();
        QueryProductsInfoRequest queryProductsInfoRequest = QueryProductsInfoRequest.builder().head(new RequestHead()).body(RequestBody.builder().agentCode(agentCode).userCode(user).build()).build();
        ProductsInfoResponse productsInfoResponse = this.subAccountService.queryProductsInfo(queryProductsInfoRequest, userCode, isDelete);
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg("\u6210\u529f");
        ajaxResultVo.setData((Object)productsInfoResponse.getBody());
        return ajaxResultVo;
    }

    @RequestMapping(value={"batchAuthorization"})
    public String batchAuthorization(Map map) {
        map.put("url", "subAccount/batchAuthorization");
        return "subAccount/batchAuthorization";
    }

    @RequestMapping(value={"saveBatchAuthorization"})
    @ResponseBody
    public Object batchAuthorization(String channelCode, String channelUser, String channelProduct) {
        List channelUsers = JSONArray.parseArray((String)channelUser, SubAccountVO.class);
        List channelProducts = JSONArray.parseArray((String)channelProduct, ProductDetailVO.class);
        String result = this.subAccountService.bitchAddProdict(channelCode, channelUsers, channelProducts);
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(result);
        return ajaxResultVo;
    }

    @RequestMapping(value={"saveAuthorization"})
    @ResponseBody
    public Object saveAuthorization(BitchSubVO bitchSubVO, HttpServletRequest request) {
        String res = this.subAccountService.subAddProdict(bitchSubVO, request.getRemoteUser());
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(res);
        return ajaxResultVo;
    }

    @RequestMapping(value={"syncUserCode"})
    @ResponseBody
    public Object syncUserCode(String channelCode, String userCode, HttpServletRequest request) {
        String remoteUser = request.getRemoteUser();
        String result = "";
        try {
            result = this.subAccountService.syncUserCode(channelCode, userCode, remoteUser);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5b50\u8d26\u53f7\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            result = "\u540c\u6b65\u5b50\u8d26\u53f7\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff01";
        }
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(result);
        return ajaxResultVo;
    }

    @RequestMapping(value={"syncChannelCode"})
    @ResponseBody
    public Object syncChannelCode(String channelCode, HttpServletRequest request) {
        String remoteUser = request.getRemoteUser();
        String result = "";
        try {
            result = this.subAccountService.syncChannelCode(channelCode, remoteUser);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u6e20\u9053\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            result = "\u540c\u6b65\u6e20\u9053\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff01";
        }
        AjaxResultVo ajaxResultVo = new AjaxResultVo();
        ajaxResultVo.setCode(Integer.valueOf(0));
        ajaxResultVo.setMsg(result);
        return ajaxResultVo;
    }

    @RequestMapping(value={"syncAll"})
    @ResponseBody
    public String syncAll() {
        String result = "";
        try {
            result = this.subAccountService.syncAll();
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u6240\u6709\u6e20\u9053\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            result = "\u540c\u6b65\u6240\u6709\u6e20\u9053\u4ea7\u54c1\u6743\u9650\u5f02\u5e38\uff01";
        }
        return result;
    }
}

