/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.platform.common.cas;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisUser;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisPermissionsMenuServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisRoleServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.service.impl.ApisUserServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.CollectionUtils;

public class CustomUserDetailsServiceImpl
implements AuthenticationUserDetailsService<CasAssertionAuthenticationToken> {
    private static final Logger log = LoggerFactory.getLogger(CustomUserDetailsServiceImpl.class);
    public static final String ROLE_ADMIN = "admin";
    public static final Integer ADMINTYPE = 1;
    final ApisUserServiceImpl apisUserService;
    final ApisRoleServiceImpl apisRoleService;
    final ApisPermissionsMenuServiceImpl apisPermissionsMenuService;

    @Autowired
    public CustomUserDetailsServiceImpl(ApisUserServiceImpl apisUserService, ApisRoleServiceImpl apisRoleService, ApisPermissionsMenuServiceImpl apisPermissionsMenuService) {
        this.apisUserService = apisUserService;
        this.apisRoleService = apisRoleService;
        this.apisPermissionsMenuService = apisPermissionsMenuService;
    }

    public UserDetails loadUserDetails(CasAssertionAuthenticationToken token) {
        List menuRoles;
        log.debug("\u5f53\u524d\u7684\u7528\u6237\u540d\u662f\uff1a{}", (Object)token.getName());
        ArrayList<SimpleGrantedAuthority> authorityList = new ArrayList<SimpleGrantedAuthority>();
        authorityList.add(new SimpleGrantedAuthority(token.getName()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)token.getName());
        ApisUser user = (ApisUser)this.apisUserService.getOne((Wrapper)queryWrapper);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (user != null && user.getUserType() != null && user.getUserType().intValue() == ADMINTYPE.intValue()) {
            authorities.add(new SimpleGrantedAuthority(ROLE_ADMIN));
        } else if (user != null && !CollectionUtils.isEmpty((Collection)(menuRoles = this.apisPermissionsMenuService.findRoleMenu(user.getId())))) {
            menuRoles.forEach(t -> {
                if (!StringUtils.isEmpty((String)t.getCode())) {
                    authorities.add(new SimpleGrantedAuthority(t.getCode()));
                }
            });
        }
        if (user == null || CollectionUtils.isEmpty(authorities)) {
            authorities.add(new SimpleGrantedAuthority("tourist"));
        }
        if (user == null || StringUtils.isEmpty((String)user.getPassword())) {
            if (user == null) {
                user = new ApisUser();
            }
            if (StringUtils.isEmpty((String)user.getUsername())) {
                user.setUsername("\u6e38\u5ba2");
            }
            user.setPassword("123");
        }
        return new User(user.getUserCode(), user.getPassword(), authorities);
    }
}

