/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.controller.log.report.ReportQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisBusiAppLog;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisBusiAppLogCopy;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisBusiAppLogMapper;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisBusiAppLogCopyService;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisBusiAppLogService;
import com.jdaz.sinosoftgz.apis.adminapp.utils.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApisBusiAppLogServiceImpl
extends ServiceImpl<ApisBusiAppLogMapper, ApisBusiAppLog>
implements IApisBusiAppLogService {
    private static final Logger log = LoggerFactory.getLogger(ApisBusiAppLogServiceImpl.class);
    @Autowired
    private IApisBusiAppLogCopyService apisBusiAppLogCopyService;
    @Autowired
    private IApisBusiAppLogService apisBusiAppLogService;
    @Autowired
    private ApisBusiAppLogMapper apisBusiAppLogMapper;

    public PageResultVo<ApisBusiAppLog> searchBy(Page page, ReportQueryVo reportQueryVo) {
        Page pages = ((ApisBusiAppLogMapper)this.baseMapper).selectByReportQueryVo(page, reportQueryVo);
        PageResultVo appLogPageResultVo = new PageResultVo();
        appLogPageResultVo.setCode(Integer.valueOf(0));
        appLogPageResultVo.setCount(Long.valueOf(pages.getTotal()));
        appLogPageResultVo.setMsg("success");
        appLogPageResultVo.setData(pages.getRecords());
        return appLogPageResultVo;
    }

    public void batchDeleteAndSynch(Integer data, Integer lastInterval) {
        Integer lastLogCopyInterval = data + lastInterval;
        String da = Tools.getLastDate((Integer)data);
        String lastLogDate = Tools.getLastDate((Integer)lastLogCopyInterval);
        Long startTime = System.currentTimeMillis();
        Long endTime = startTime + 10800000L;
        if (Objects.nonNull(da)) {
            while (endTime > System.currentTimeMillis()) {
                Integer logCount = 0;
                Integer logCopyCount = 0;
                ApisBusiAppLog apisBusiAppLogEntity = new ApisBusiAppLog();
                apisBusiAppLogEntity.setCreateTime((Date)DateUtil.parse((CharSequence)da));
                List logList = this.selectAllApisBusiAppLog(apisBusiAppLogEntity);
                logCount = logList.size();
                this.apisBusiAppLogService.beginTransaction(logList);
                if (lastLogCopyInterval > data) {
                    ApisBusiAppLogCopy paramsEntity = new ApisBusiAppLogCopy();
                    paramsEntity.setLogTime((Date)DateUtil.parse((CharSequence)lastLogDate));
                    List appLogCopyList = this.apisBusiAppLogCopyService.selectAllApisBusiAppLogCopy(paramsEntity);
                    if (appLogCopyList != null && appLogCopyList.size() > 0) {
                        appLogCopyList.stream().forEach(item -> this.apisBusiAppLogCopyService.deleteApisBusiAppLogCopyById(item.getId()));
                        logCopyCount = appLogCopyList.size();
                        log.warn("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664copy\u8868\u6570\u636e\u6761\u6570\uff1a{}", (Object)appLogCopyList.size());
                    }
                }
                if (logCount >= 500 || logCopyCount >= 500) continue;
                break;
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void beginTransaction(List<ApisBusiAppLog> logList) {
        Boolean is;
        ArrayList<ApisBusiAppLogCopy> appLogCopies = new ArrayList<ApisBusiAppLogCopy>();
        for (ApisBusiAppLog appLog : logList) {
            ApisBusiAppLogCopy apisBusiAppLogCopy = new ApisBusiAppLogCopy();
            BeanUtils.copyProperties((Object)appLog, (Object)apisBusiAppLogCopy);
            appLogCopies.add(apisBusiAppLogCopy);
        }
        if (appLogCopies.size() > 0 && (is = Boolean.valueOf(this.apisBusiAppLogCopyService.saveBatch(appLogCopies))).booleanValue()) {
            List longList = logList.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.deleteApisBusiAppLogByIds(longList);
        }
    }

    public void deleteApisBusiAppLogByIds(List<Long> ids) {
        try {
            ids.stream().forEach(id -> this.apisBusiAppLogMapper.deleteApisBusiAppLogById(id));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u65e5\u5fd7\u64cd\u4f5c\u62a5\u9519");
        }
    }

    public List<ApisBusiAppLog> selectAllApisBusiAppLog(ApisBusiAppLog apisBusiAppLog) {
        return this.apisBusiAppLogMapper.selectAllApisBusiAppLog(apisBusiAppLog);
    }

    public ApisBusiAppLog getFilterApisBusiAppLog(Long id) {
        Function<ApisBusiAppLog, ApisBusiAppLog> convertDataFunction = hit -> {
            if (!hit.getLogContent().startsWith("<?xml version=\"1.0\"")) {
                try {
                    JSONObject object = JSONObject.parseObject((String)hit.getLogContent());
                    String pretty = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                    hit.setLogContent(pretty);
                }
                catch (Exception e) {
                    log.error("ApisBusiAppLog\u683c\u5f0f\u5316json\u62a5\u9519");
                    return hit;
                }
            }
            return hit;
        };
        ApisBusiAppLog apisBusiAppLog = (ApisBusiAppLog)this.getById((Serializable)id);
        if (Objects.nonNull(apisBusiAppLog) && Objects.nonNull(apisBusiAppLog.getLogContent())) {
            convertDataFunction.apply(apisBusiAppLog);
        }
        return apisBusiAppLog;
    }
}

