/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.product.ChannelProductQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.user.ChannelUserController;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelProduct;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisBusiAppLogMapper;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisChannelProductMapper;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelProductService;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.SyncProductRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.body.info.SyncProductInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApisChannelProductServiceImpl
extends ServiceImpl<ApisChannelProductMapper, ApisChannelProduct>
implements IApisChannelProductService {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUserController.class);
    @Autowired
    private ApisChannelProductMapper apisChannelProductMapper;
    @Autowired
    private ApisBusiAppLogMapper apisBusiAppLogMapper;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;

    public PageResultVo<ApisChannelProduct> searchBy(Page<ApisChannelProduct> page, ChannelProductQueryVo channelProductQueryVo) {
        Page pages = ((ApisChannelProductMapper)this.baseMapper).selectByChannelProductQueryVo(page, channelProductQueryVo);
        PageResultVo resultVo = new PageResultVo();
        resultVo.setCode(Integer.valueOf(0));
        resultVo.setCount(Long.valueOf(pages.getTotal()));
        resultVo.setData(pages.getRecords());
        resultVo.setMsg("success");
        return resultVo;
    }

    public Object preEditValidate(ApisChannelProduct channelProduct) {
        QueryWrapper qw = new QueryWrapper();
        List<String> planList = Arrays.asList(channelProduct.getPlanCode().split(","));
        List<String> productList = Arrays.asList(channelProduct.getProductCode().split(","));
        if (productList.size() == planList.size()) {
            for (int i = 0; i < productList.size(); ++i) {
                qw.eq((Object)"user_code", (Object)channelProduct.getUserCode());
                qw.eq((Object)"product_code", (Object)productList.get(i));
                qw.eq((Object)"plan_code", (Object)planList.get(i));
                if (channelProduct.getId() != null) {
                    qw.ne((Object)"id", (Object)channelProduct.getId());
                }
                if (this.count((Wrapper)qw) <= 0) continue;
                throw new ValidateException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4ea7\u54c1\u7f16\u7801");
            }
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void synchronousProduct(SyncProductRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getBody().toString())) {
            throw new Exception("body\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getBody().getAgentCode())) {
            throw new Exception("AgentCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getHead().toString())) {
            throw new Exception("head\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getHead().getSeqNo())) {
            throw new Exception("seqNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (request.getBody().getSyncProductInfoList() == null) {
            throw new Exception("syncProductInfoList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List syncProductInfoList = request.getBody().getSyncProductInfoList();
        for (SyncProductInfo temp : syncProductInfoList) {
            if ("A".equals(temp.getOperatorType())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"channel_code", (Object)request.getBody().getAgentCode());
                List apisChannelUserList = this.apisChannelUserMapper.selectList((Wrapper)queryWrapper);
                for (ApisChannelUser user : apisChannelUserList) {
                    ApisChannelProduct apisChannelProduct = new ApisChannelProduct();
                    apisChannelProduct.setChannelCode(request.getBody().getAgentCode());
                    apisChannelProduct.setProductCode(temp.getProductCode());
                    apisChannelProduct.setPlanCode(temp.getPlanCode());
                    apisChannelProduct.setGoodsCode(temp.getGoodsCode());
                    apisChannelProduct.setUserCode(user.getUserCode());
                    apisChannelProduct.setEffectiveDate(new Date());
                    apisChannelProduct.setDeleted(Integer.valueOf(0));
                    apisChannelProduct.setValidFlag(Boolean.valueOf(true));
                    if (this.apisChannelProductMapper.insert((Object)apisChannelProduct) > 0) continue;
                    throw new Exception("\u63d2\u5165\u5931\u8d25\uff01apisChannelProduct.toString()\uff1a" + apisChannelProduct.toString());
                }
                continue;
            }
            if ("D".equals(temp.getOperatorType())) {
                ApisChannelProduct apisChannelProduct = new ApisChannelProduct();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"channel_code", (Object)request.getBody().getAgentCode());
                queryWrapper.eq((Object)"product_code", (Object)temp.getProductCode());
                queryWrapper.eq((Object)"plan_Code", (Object)temp.getPlanCode());
                queryWrapper.eq((Object)"deleted", (Object)0);
                List apisChannelProductList = this.apisChannelProductMapper.selectList((Wrapper)queryWrapper);
                for (ApisChannelProduct deleteTemp : apisChannelProductList) {
                    UpdateWrapper updateWrapper = new UpdateWrapper();
                    ApisChannelProduct apisChannelProductDelete = new ApisChannelProduct();
                    apisChannelProductDelete.setDeleted(Integer.valueOf(1));
                    apisChannelProductDelete.setDeleteTime(new Date());
                    updateWrapper.eq((Object)"id", (Object)deleteTemp.getId());
                    if (this.apisChannelProductMapper.delete((Wrapper)updateWrapper) > 0) continue;
                    throw new Exception("\u903b\u8f91\u5220\u9664\u5931\u8d25\uff01apisChannelProduct.toString()\uff1a" + apisChannelProduct.toString());
                }
                continue;
            }
            throw new Exception("OperatorType\u503c\u9519\u8bef\uff01");
        }
    }
}

