/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.controller.cache.vo.CacheVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.channel.user.ChannelUserQueryVo;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.ApisCachePage;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.adminapp.exception.ValidateException;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisCacheMapper;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisChannelUserService;
import com.jdaz.sinosoftgz.apis.cache.loader.vo.CacheLoaderProperties;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.UpdateChannelDataRequest;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApisChannelUserServiceImpl
extends ServiceImpl<ApisChannelUserMapper, ApisChannelUser>
implements IApisChannelUserService {
    @Autowired
    private ApisCacheMapper apisCacheMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;
    @Value(value="${apis.cache.loader.redis-url}")
    private String redisUrl;
    private RedisClient client = null;
    private StatefulRedisConnection<String, String> connection;
    private Set<String> rowHashs = new /* Unavailable Anonymous Inner Class!! */;
    private Set<String> typeList = new /* Unavailable Anonymous Inner Class!! */;
    private Set<String> typeOtherHash = new /* Unavailable Anonymous Inner Class!! */;

    @PostConstruct
    void init() {
        this.client = RedisClient.create((String)this.redisUrl);
        this.connection = this.client.connect();
    }

    @PreDestroy
    void destroy() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public PageResultVo searchByRedis(Page page, CacheVo cacheVo) {
        ArrayList mapList = new ArrayList();
        if (this.connection != null && this.connection.isOpen()) {
            Map map;
            if (this.typeOtherHash.contains(cacheVo.getPrefix())) {
                map = this.connection.sync().hgetall((Object)cacheVo.getTextName());
                for (Map.Entry str : map.entrySet()) {
                    HashMap objectMap = new HashMap();
                    objectMap.put("key", cacheVo.getTextName());
                    objectMap.put("value", str.getValue());
                    objectMap.put("filed", str.getKey());
                    mapList.add(objectMap);
                }
            } else if (this.typeList.contains(cacheVo.getPrefix())) {
                Set ob = this.connection.sync().smembers((Object)cacheVo.getTextName());
                if (null != ob && !ob.isEmpty()) {
                    for (String value : ob) {
                        HashMap<String, String> objectMap = new HashMap<String, String>();
                        objectMap.put("key", cacheVo.getTextName());
                        objectMap.put("value", value);
                        mapList.add(objectMap);
                    }
                }
            } else if (this.rowHashs.contains(cacheVo.getPrefix())) {
                map = this.connection.sync().hgetall((Object)cacheVo.getTextName());
                for (Map.Entry str : map.entrySet()) {
                    HashMap objectMap = new HashMap();
                    objectMap.put("key", cacheVo.getTextName());
                    objectMap.put("value", str.getValue());
                    objectMap.put("filed", str.getKey());
                    mapList.add(objectMap);
                }
            }
        }
        PageResultVo resultVo = new PageResultVo();
        resultVo.setCode(Integer.valueOf(0));
        resultVo.setCount(Long.valueOf(mapList.size()));
        resultVo.setMsg("success");
        if (mapList.size() > 15) {
            Integer from = Integer.valueOf((page.getCurrent() - 1L) * 15L + "");
            Integer to = Integer.valueOf(page.getCurrent() * 15L + "");
            if (to > mapList.size()) {
                to = mapList.size();
            }
            resultVo.setData(Collections.unmodifiableList(mapList.subList(from, to)));
        } else {
            resultVo.setData(mapList);
        }
        return resultVo;
    }

    public PageResultVo getRedis(Page page, ApisCachePage apisCachePage) {
        Page page1 = this.apisCacheMapper.selectByCache(page, apisCachePage);
        PageResultVo resultVo = new PageResultVo();
        resultVo.setCode(Integer.valueOf(0));
        resultVo.setCount(Long.valueOf(page1.getTotal()));
        resultVo.setMsg("success");
        resultVo.setData(page1.getRecords());
        return resultVo;
    }

    public PageResultVo searchByDate(Page page, CacheVo cacheVo) {
        ArrayList mapList = new ArrayList();
        PageResultVo resultVo = new PageResultVo();
        resultVo.setCode(Integer.valueOf(0));
        resultVo.setMsg("success");
        resultVo.setData(mapList);
        return resultVo;
    }

    private List<Map<String, Object>> getTypeList(List<Map<String, Object>> page, CacheLoaderProperties.Config config) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> data : page) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            String key = null;
            key = config.getPrefix() == null || config.getPrefix().trim().equals("") ? data.get(config.getKeyName()).toString() : config.getPrefix() + ":" + data.get(config.getKeyName()).toString();
            if (data.get(config.getKeyName()) != null) {
                if (data.get("_value") != null) {
                    objectMap.put("key", key);
                    objectMap.put("value", data.get("_value").toString());
                    objectMap.put("filed", data.get("_key").toString());
                }
                mapList.add(objectMap);
            }
            if (data.get("_value") != null) {
                objectMap.put("key", key);
                objectMap.put("value", data.get("_value").toString());
            }
            mapList.add(objectMap);
        }
        return mapList;
    }

    private List<Map<String, Object>> getTypeJson(List<Map<String, Object>> page, CacheLoaderProperties.Config config) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> data : page) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            String key = null;
            key = config.getPrefix() == null || config.getPrefix().trim().equals("") ? data.get(config.getKeyName()).toString() : config.getPrefix() + ":" + data.get(config.getKeyName()).toString();
            if (data.get(config.getKeyName()) == null) continue;
            if (data.get("_value") != null) {
                objectMap.put("key", key);
                objectMap.put("value", data.get("_value").toString());
                objectMap.put("filed", data.get("_key").toString());
            }
            mapList.add(objectMap);
        }
        return mapList;
    }

    private List<Map<String, Object>> getTypeOtherHash(List<Map<String, Object>> page, CacheLoaderProperties.Config config) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> data : page) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            String key = null;
            key = config.getPrefix() == null || config.getPrefix().trim().equals("") ? data.get(config.getKeyName()).toString() : config.getPrefix() + ":" + data.get(config.getKeyName()).toString();
            if (data.get(config.getKeyName()) == null) continue;
            if (data.get("_value") != null) {
                objectMap.put("key", key);
                objectMap.put("value", data.get("_value") != null ? data.get("_value").toString() : "");
                objectMap.put("filed", data.get("_key").toString());
            }
            mapList.add(objectMap);
        }
        return mapList;
    }

    private List<Map<String, Object>> getRowHash(List<Map<String, Object>> page, CacheLoaderProperties.Config config) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> data : page) {
            if (data.get(config.getKeyName()) == null) continue;
            String key = data.get(config.getKeyName()).toString();
            for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
                HashMap<String, String> objectMap = new HashMap<String, String>();
                if (config.getPrefix() == null || config.getPrefix().trim().equals("")) {
                    objectMap.put("key", key);
                    objectMap.put("value", stringObjectEntry.getValue() != null ? stringObjectEntry.getValue().toString() : "");
                    objectMap.put("filed", stringObjectEntry.getKey());
                } else {
                    objectMap.put("key", config.getPrefix() + ":" + key);
                    objectMap.put("value", stringObjectEntry.getValue() != null ? stringObjectEntry.getValue().toString() : "");
                    objectMap.put("filed", stringObjectEntry.getKey());
                }
                mapList.add(objectMap);
            }
        }
        return mapList;
    }

    public PageResultVo searchBy(Page page, ChannelUserQueryVo channelUserQueryVo) {
        Page pages = ((ApisChannelUserMapper)this.baseMapper).selectByChannelUserQueryVo(page, channelUserQueryVo);
        PageResultVo resultVo = new PageResultVo();
        resultVo.setCode(Integer.valueOf(0));
        resultVo.setCount(Long.valueOf(pages.getTotal()));
        resultVo.setMsg("success");
        resultVo.setData(pages.getRecords());
        return resultVo;
    }

    public Object checkUserCode(ApisChannelUser channelUser) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"user_code", (Object)channelUser.getUserCode());
        if (channelUser.getId() != null) {
            qw.ne((Object)"id", (Object)channelUser.getId());
        }
        if (this.count((Wrapper)qw) > 0) {
            throw new ValidateException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7528\u6237\u7f16\u7801");
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateChannelData(UpdateChannelDataRequest request, String operateCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getBody().toString())) {
            throw new Exception("body\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getBody().getAgentCode())) {
            throw new Exception("AgentCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (request.getHead() == null) {
            throw new Exception("head\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getHead().getSeqNo())) {
            throw new Exception("seqNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"channel_code", (Object)request.getBody().getAgentCode());
        List apisChannelUserList = this.apisChannelUserMapper.selectList((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)apisChannelUserList)) {
            for (ApisChannelUser user : apisChannelUserList) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                ApisChannelUser temp = new ApisChannelUser();
                if (StringUtils.isNotBlank((CharSequence)request.getBody().getAgentName())) {
                    temp.setChannelName(request.getBody().getAgentName());
                }
                if (StringUtils.isNotBlank((CharSequence)request.getBody().getBranchCode())) {
                    temp.setComCode(request.getBody().getBranchCode());
                    temp.setMakeCom(request.getBody().getBranchCode());
                }
                temp.setModifier(operateCode);
                temp.setUpdateTime(new Date());
                updateWrapper.eq((Object)"id", (Object)user.getId());
                if (this.apisChannelUserMapper.update((Object)temp, (Wrapper)updateWrapper) > 0) continue;
                throw new Exception("\u5931\u8d25\uff01");
            }
        }
    }

    public boolean redisSetRemove(String key, String value) {
        long num = this.connection.sync().srem((Object)key, (Object[])new String[]{value});
        return num > 0L;
    }

    public boolean redisSetUpdate(String originKey, String originValue, String key, String value) {
        try {
            this.connection.sync().multi();
            this.connection.sync().srem((Object)originKey, (Object[])new String[]{originValue});
            this.connection.sync().sadd((Object)key, (Object[])new String[]{value});
            this.connection.sync().exec();
            return true;
        }
        catch (Exception e) {
            this.connection.sync().discard();
            throw e;
        }
    }
}

