/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.page.RoleDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisPermissionsMenu;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisRole;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisPermissionsMenuMapper;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisRoleMapper;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisRolePremsLinksMapper;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ApisRoleServiceImpl
extends ServiceImpl<ApisRoleMapper, ApisRole>
implements IApisRoleService {
    @Autowired
    private ApisRoleMapper apisRoleMapper;
    @Autowired
    private ApisPermissionsMenuMapper apisPermissionsMenuMapper;
    @Autowired
    private ApisRolePremsLinksMapper apisRolePremsLinksMapper;

    public List<ApisRole> getList(Map queryMap) {
        return this.apisRoleMapper.getList(queryMap);
    }

    public PageResultVo<ApisRole> selectByRoleManageQueryDTO(Page page, ApisRole apisRole) throws Exception {
        Page pages = ((ApisRoleMapper)this.baseMapper).selectByRoleManageQueryDTO(page, apisRole);
        PageResultVo temp = new PageResultVo();
        temp.setCode(Integer.valueOf(0));
        temp.setCount(Long.valueOf(pages.getTotal()));
        temp.setMsg("success");
        temp.setData(pages.getRecords());
        return temp;
    }

    public List<Map<String, Object>> getAllRoleTree() {
        return this.getRoleChildrenTree(null);
    }

    private List<Map<String, Object>> getRoleChildrenTree(String parentId) {
        ArrayList<Map<String, Object>> menuList = new ArrayList<Map<String, Object>>();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)parentId)) {
            wrapper.and(wp -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wp.eq((Object)"parent_id", (Object)"")).or()).isNull((Object)"parent_id");
            });
        } else {
            wrapper.eq((Object)"parent_id", (Object)parentId);
        }
        wrapper.eq((Object)"delete_flag", (Object)0);
        wrapper.orderByAsc((Object)"show_idx");
        List adminMenuList = this.apisPermissionsMenuMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)adminMenuList)) {
            for (ApisPermissionsMenu menu : adminMenuList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("title", menu.getName());
                map.put("id", menu.getId());
                map.put("field", "tree");
                List childrenList = this.getRoleChildrenTree(menu.getId().toString());
                if (!CollectionUtils.isEmpty((Collection)childrenList)) {
                    map.put("children", childrenList);
                }
                menuList.add(map);
            }
        }
        return menuList;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> saveRoles(RoleDTO roleDTO) throws Exception {
        boolean isUpdate = false;
        ApisRole role = null;
        if (StringUtils.isNotEmpty((CharSequence)roleDTO.getId())) {
            role = (ApisRole)this.apisRoleMapper.selectById((Serializable)Long.valueOf(Long.parseLong(roleDTO.getId())));
        }
        if (role == null) {
            role = new ApisRole();
            roleDTO.setId(Long.toString(IdWorker.getId()));
        } else {
            isUpdate = true;
        }
        role.setId(Long.valueOf(Long.parseLong(roleDTO.getId())));
        role.setName(roleDTO.getName());
        role.setValidFlag(Integer.valueOf(roleDTO.getValidFlag()));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"name", (Object)roleDTO.getName());
        List datas = this.apisRoleMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            for (ApisRole t : datas) {
                if (!isUpdate) {
                    throw new Exception("\u89d2\u8272\u540d:" + t.getName() + "\u5df2\u5b58\u5728\uff01");
                }
                if (!isUpdate || role.getId().equals(t.getId())) continue;
                throw new Exception("\u89d2\u8272\u540d:" + t.getName() + "\u5df2\u5b58\u5728\uff01");
            }
        }
        try {
            if (isUpdate) {
                if (this.apisRoleMapper.updateById((Object)role) <= 0) {
                    throw new Exception("\u5931\u8d25");
                }
                if (this.apisRolePremsLinksMapper.deleteRolePermsLinksByRoleId(role.getId()) < 0) {
                    throw new Exception("\u5931\u8d25");
                }
                for (String id : roleDTO.getTree()) {
                    if (this.apisRolePremsLinksMapper.insertRolePermLinks(IdWorker.getId(), role.getId(), Long.parseLong(id)) > 0) continue;
                    throw new Exception("\u5931\u8d25");
                }
            } else {
                if (this.apisRoleMapper.insert((Object)role) <= 0) {
                    throw new Exception("\u5931\u8d25");
                }
                for (String id : roleDTO.getTree()) {
                    Long idworker = IdWorker.getId();
                    if (this.apisRolePremsLinksMapper.insertRolePermLinks(idworker.longValue(), role.getId(), Long.parseLong(id)) > 0) continue;
                    throw new Exception("\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u5931\u8d25", (Throwable)e);
            throw new Exception("\u8bf7\u52fe\u9009\u89d2\u8272\u6743\u9650");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", 1);
        resultMap.put("msg", "\u4fdd\u5b58\u6210\u529f\uff01");
        return resultMap;
    }
}

