/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.adminapp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.adminapp.controller.DTO.page.UserManagePageDTO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.ApisRolePermissionsVO;
import com.jdaz.sinosoftgz.apis.adminapp.controller.vo.PageResultVo;
import com.jdaz.sinosoftgz.apis.adminapp.entity.ApisUser;
import com.jdaz.sinosoftgz.apis.adminapp.mapper.ApisUserMapper;
import com.jdaz.sinosoftgz.apis.adminapp.service.IApisUserService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApisUserServiceImpl
extends ServiceImpl<ApisUserMapper, ApisUser>
implements IApisUserService {
    @Autowired
    private ApisUserMapper apisUserMapper;

    public List<ApisRolePermissionsVO> getRolePermissionsByList(Map parmMap) {
        return this.apisUserMapper.getRolePermissionsByList(parmMap);
    }

    public PageResultVo<UserManagePageDTO> selectByUserManageQueryDTO(Page page, UserManagePageDTO userManagePageDTO) throws Exception {
        Page pages = ((ApisUserMapper)this.baseMapper).selectByUserManageQueryDTO(page, userManagePageDTO);
        PageResultVo temp = new PageResultVo();
        temp.setCode(Integer.valueOf(0));
        temp.setCount(Long.valueOf(pages.getTotal()));
        temp.setMsg("success");
        temp.setData(pages.getRecords());
        return temp;
    }

    public ApisUser getUserDetail(String userId) {
        return this.apisUserMapper.getUserDetail(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveUser(JSONObject date) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_Code", (Object)date.getString("userCode"));
        ApisUser user = (ApisUser)this.getOne((Wrapper)queryWrapper);
        if (user != null) {
            throw new Exception("\u8be5\u7528\u6237\u5df2\u5b58\u5728userCode:" + date.get((Object)"userCode").toString());
        }
        SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ApisUser insertUser = new ApisUser();
        insertUser.setUsername(date.get((Object)"userName").toString());
        insertUser.setUserCode(date.getString("userCode"));
        insertUser.setUserType(Integer.valueOf(Integer.parseInt(date.getString("userType"))));
        insertUser.setEmail(date.get((Object)"email") == null ? "" : date.get((Object)"email").toString());
        insertUser.setPhone(date.get((Object)"mobilePhone") == null ? "" : date.get((Object)"mobilePhone").toString());
        insertUser.setPassword(date.get((Object)"password").toString());
        insertUser.setSexType(date.getString("sex") == null ? null : Integer.valueOf(Integer.parseInt(date.getString("sex"))));
        insertUser.setLastLoginTime(date.getString("lastTime") == null ? null : sm.parse(date.getString("lastTime")));
        insertUser.setLastLoginIp(date.get((Object)"lastIp") == null ? "" : date.get((Object)"lastIp").toString());
        insertUser.setDateCreated(date.getString("createTime") == null ? null : sm.parse(date.getString("createTime")));
        insertUser.setLastUpdated(date.getString("updateTime") == null ? null : sm.parse(date.getString("updateTime")));
        if (this.apisUserMapper.insert((Object)insertUser) <= 0) {
            throw new Exception("\u5931\u8d25");
        }
    }

    public List<ApisRolePermissionsVO> getRolePermissionsAdminByList(Map parmMap) {
        return this.apisUserMapper.getRolePermissionsAdminByList(parmMap);
    }
}

