//处理json数据
function getOneByForm() {
    var url = $("#url_input").val();
    var body = $("#body_input").val();
    var type = $("#type_select").val();
    var headers = $("#header_input").val();

    $.ajax({
        url: url,//请求地址
        // data: {id: 3},//提交的数据
        data: body.toString(),//提交的数据
        contentType: "application/xml; charset=UTF-8",
        type: type,//提交的方式
        crossDomain: true,
        dataType: "TEXT", //返回类型 TEXT：字符串 JSON XML
        beforeSend: function (xhr) {
        xhr.setRequestHeader("Authorization", "Bearer XXX");
        // xhr.setRequestHeader("aaaa", "1111");
    },
    success: function (data) { // 校验返回内容，进行跳转
        //将获取到的数据输出到元素上
        $("#showArea").text(data);
        console.log(data);
    },
    error: function (xhr) {
        clearShowArea();
        // 失败输出HTTP状态码
        alert("调用失败！HTTP状态码：" + xhr.status);
    }
})
/*$.cors(url, {}, function (json) {
    if (json.code == 0) {
        //将获取到的数据输出到元素上
        $("#showArea").text(data);
        console.log(data);
    } else {
        alert("调用失败!！HTTP状态码：" + json.code);
    }
});*/
}

function getOneByJson() {
    var url = $("#url_input").val();
    var body = $("#body_input").val();
    var type = $("#type_select").val();
    var businessType = $("#businessType").val();
    var transaction = $("#transaction").val();
    var channelUser = $("#channelUser").val();
    var token = $("#token").val();

    $.ajax({
        url: url,//请求地址
        data: body,//提交的数据
        contentType: "application/json; charset=utf-8",
        crossDomain: true,
        type: type,//提交的方式
        dataType: "TEXT", //返回类型 TEXT：字符串 JSON XML
        beforeSend: function (xhr) {
            xhr.setRequestHeader("business-type", businessType);
            xhr.setRequestHeader("transaction-no", transaction);
            xhr.setRequestHeader("channel-user", channelUser);
            xhr.setRequestHeader("token", token);
        },
        success: function (data) { // 校验返回内容，进行跳转
            //将获取到的数据输出到元素上
            $("#showArea").text(data);
            console.log(data);
        },
        error: function (xhr) {
            clearShowArea();
            // 失败输出HTTP状态码
            alert("调用失败！HTTP状态码：" + xhr.status);
        }
    })
}

//  清空结果
function clearShowArea() {
    $("#showArea").empty();
}

// 发送请求方法入口，判断数据类型分别调用对应方法
function send() {
    var bodyType = $('input:radio[name=bodyType]:checked').val();
    console.log("bodyType: " + bodyType)
    if (bodyType == "xml") {
        getOneByForm();
    } else if (bodyType == "json") {
        getOneByJson();
    } else {
        alert("不支持该类型：" + bodyType)
    }
}

function jsonToFormData(json) {
    var object = JSON.parse(body);
    var rs = "";
    object.key(obj).forEach()
    {
        rs = {}
    }
}

// 跳转首页
function toIndex() {
    window.location.href = '/';
}


//格式化代码函数,已经用原生方式写好了不需要改动,直接引用就好
var formatJson = function (json, options) {
    var reg = null,
        formatted = '',
        pad = 0,
        PADDING = ' ';
    options = options || {};
    options.newlineAfterColonIfBeforeBraceOrBracket = (options.newlineAfterColonIfBeforeBraceOrBracket === true) ? true : false;
    options.spaceAfterColon = (options.spaceAfterColon === false) ? false : true;
    if (typeof json !== 'string') {
        json = JSON.stringify(json);
    } else {
        json = JSON.parse(json);
        json = JSON.stringify(json);
    }
    reg = /([\{\}])/g;
    json = json.replace(reg, '\r\n$1\r\n');
    reg = /([\[\]])/g;
    json = json.replace(reg, '\r\n$1\r\n');
    reg = /(\,)/g;
    json = json.replace(reg, '$1\r\n');
    reg = /(\r\n\r\n)/g;
    json = json.replace(reg, '\r\n');
    reg = /\r\n\,/g;
    json = json.replace(reg, ',');
    if (!options.newlineAfterColonIfBeforeBraceOrBracket) {
        reg = /\:\r\n\{/g;
        json = json.replace(reg, ':{');
        reg = /\:\r\n\[/g;
        json = json.replace(reg, ':[');
    }
    if (options.spaceAfterColon) {
        reg = /\:/g;
        json = json.replace(reg, ':');
    }
    (json.split('\r\n')).forEach(function (node, index) {
            var i = 0,
                indent = 0,
                padding = '';
            if (node.match(/\{$/) || node.match(/\[$/)) {
                indent = 1;
            } else if (node.match(/\}/) || node.match(/\]/)) {
                if (pad !== 0) {
                    pad -= 1;
                }
            } else {
                indent = 0;
            }
            for (i = 0; i < pad; i++) {
                padding += PADDING;
            }
            formatted += padding + node + '\r\n';
            pad += indent;
        }
    );
    return formatted;
}




//格式化代码函数
String.prototype.removeLineEnd = function () {
    return this.replace(/(<.+?\s+?)(?:\n\s*?(.+?=".*?"))/g, '$1 $2')
}
function formatXml(text) {
    //去掉多余的空格
    text = '\n' + text.replace(/(<\w+)(\s.*?>)/g, function ($0, name, props) {
        return name + ' ' + props.replace(/\s+(\w+=)/g, " $1");
    }).replace(/>\s*?</g, ">\n<");
    //把注释编码
    text = text.replace(/\n/g, '\r').replace(/<!--(.+?)-->/g, function ($0, text) {
        var ret = '<!--' + escape(text) + '-->';
        //alert(ret);
        return ret;
    }).replace(/\r/g, '\n');
    //调整格式
    var rgx = /\n(<(([^\?]).+?)(?:\s|\s*?>|\s*?(\/)>)(?:.*?(?:(?:(\/)>)|(?:<(\/)\2>)))?)/mg;
    var nodeStack = [];
    var output = text.replace(rgx, function ($0, all, name, isBegin, isCloseFull1, isCloseFull2, isFull1, isFull2) {
        var isClosed = (isCloseFull1 == '/') || (isCloseFull2 == '/' ) || (isFull1 == '/') || (isFull2 == '/');
        //alert([all,isClosed].join('='));
        var prefix = '';
        if (isBegin == '!') {
            prefix = getPrefix(nodeStack.length);
        }
        else {
            if (isBegin != '/') {
                prefix = getPrefix(nodeStack.length);
                if (!isClosed) {
                    nodeStack.push(name);
                }
            }
            else {
                nodeStack.pop();
                prefix = getPrefix(nodeStack.length);
            }
        }
        var ret = '\n' + prefix + all;
        return ret;
    });
    var prefixSpace = -1;
    var outputText = output.substring(1);
    //alert(outputText);
    //把注释还原并解码，调格式
    outputText = outputText.replace(/\n/g, '\r').replace(/(\s*)<!--(.+?)-->/g, function ($0, prefix, text) {
        //alert(['[',prefix,']=',prefix.length].join(''));
        if (prefix.charAt(0) == '\r')
            prefix = prefix.substring(1);
        text = unescape(text).replace(/\r/g, '\n');
        var ret = '\n' + prefix + '<!--' + text.replace(/^\s*/mg, prefix) + '-->';
        //alert(ret);
        return ret;
    });
    return outputText.replace(/\s+$/g, '').replace(/\r/g, '\r\n');
}
function getPrefix(prefixIndex) {
    var span = ' ';
    var output = [];
    for (var i = 0; i < prefixIndex; ++i) {
        output.push(span);
    }
    return output.join('');
}

function tojson() {
    var text = $("#showArea").val();
    var format = $('input[name="bodyType"]:checked').val();
    /*alert(format + "***" + text);*/
    if (format == "xml") {
        text = formatXml(text);
        $("#showArea").val(text);
    } else {
        text = formatJson(text);
        $("#showArea").val(text);
    }
}
