<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label" style="width: 130px">商品代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="goodsCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label" style="width: 150px">商品名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="goodsCname" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="insuredTypeIndexToolbar">
            <div class="layui-btn-container">
                    <button id="data-add-btn" class="layui-btn layui-btn-sm"> 添加 </button>
                    <button id="uploadExcel" class="layui-btn layui-btn-sm"> 上传 </button>
            </div>
        </script>
        <script type="text/html" id="productTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
        </script>
    </div>
</div>
<#include "../layout/body_js.ftl"/>
<script>

    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table','upload'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table,
            upload = layui.upload;

        table.render({
            elem: '#currentTableId',
            url: '${ctx}/renewal/busiRenewal/page',
            toolbar:'#insuredTypeIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                // {field: 'id', width: 160, title: 'ID', sort: true},
                {field: 'goodsCode', width:'20%',  title: '商品代码'},
                {field: 'goodsCname', width:'50%', title: '商品名称'},
                {field: 'renewalFlag', width:'20%', title: '是否允许续保',templet: function (d) {
                        return d.renewalFlag=='Y'? '是':'否'
                    }},
                {title: '操作',width:'10%',  templet: '#productTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true,
            done: function(res, curr, count){
                bindTableToolbarFunction();
            }
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        $(document).on("click", "#data-add-btn", function () {
            var index = layer.open({
                title: '添加被保险类型',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/renewal/busiRenewal/addOrEditPage',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '查看详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/renewal/busiRenewal/addOrEditPage?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });
        <#--var uploadLoading;-->
        <#--upload.render({-->
            <#--elem: '#uploadExcel'-->
            <#--,url: '${ctx}/renewal/busiRenewal/uploadData'-->
            <#--,accept: 'file'-->
            <#--,exts: 'xls|xlsx'-->
            <#--,before:function(){-->
                <#--uploadLoading=layer.msg('正在上传中...', {icon: 16,scrollbar: false,time: 0});-->
            <#--},-->
            <#--done: function(res){-->
                <#--layer.msg('上传成功',{icon:1});-->
                <#--layer.close(uploadLoading);-->
                <#--table.reload("currentTableId");-->
            <#--}-->
        <#--});-->


    });


    function bindTableToolbarFunction() {
        var uploadLoading;
        layui.use(['upload','table'], function () {
            var upload = layui.upload,
                table=layui.table;
            upload.render({
                elem: '#uploadExcel'
                ,url: '${ctx}/renewal/busiRenewal/uploadData'
                ,accept: 'file'
                ,exts: 'xls|xlsx'
                ,before:function(){
                    uploadLoading=layer.msg('正在上传中...', {icon: 16,scrollbar: false,time: 0});
                },
                done: function(res){
                    layer.msg('上传成功',{icon:1});
                    layer.close(uploadLoading);
                    table.reload("currentTableId");
                }
            });
        });

    }
</script>
</body>
</html>
