<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">用户编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="valueType" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">配置编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="prefix" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">产品代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="loadType" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
<#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
            <#--<button class="layui-btn" href="javascript:;" data-iframe-tab="${ctx}/channel/configs/add" data-title="添加主路由信息" data-icon="fa fa-plus-circle">添加</button>-->
<#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <script type="text/html" id="channelConfigsIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","cache-page-Button-add")'>
                    <button id="channel-configs-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","cache-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn"> 删除 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="channelConfigsTableId" lay-filter="channelConfigsTableFilter"></table>
        <script type="text/html" id="channelConfigsTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/channel/configs/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","cache-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","cache-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#channelConfigsTableId',
            url: '${ctx}/cache/getCachePage',
            toolbar: '#channelConfigsIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox", width: 50, fixed: "left"},
                {field: 'id', width: 50, title: 'ID', sort: true},
                {field: 'descs', width: 100, title: '描述'},
                {field: 'prefix', width: 100, title: '前缀'},
                {field: 'valueType', width: 100, title: '值类型'},
                {field: 'loadType', width: 100, title: '加载类型'},
                {field: 'reloadTime', width: 100, title: '间隔时间'},
                {field: 'keyName', width: 100, title: '键值名'},
                {field: 'sqls', width: 300, title: 'sql语句'},
                {title: '操作', minWidth: 50, templet: '#channelConfigsTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('channelConfigsTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click","#channel-configs-add-btn",function () {
            var index = layer.open({
                title: '添加渠道配置',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/cache/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(channelConfigsTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑配置信息',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/cache/edit?id='+data.id,
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/configs/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });

    });
</script>
</body>
</html>
