<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
        .layui-form-label {
            width: 90px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <#if channelApi?? && channelApi.id?? >
                <input type="hidden" name="id" value="${channelApi.id?c}">
            </#if>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">外部渠道代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="channelCode" placeholder="请输入" autocomplete="off"  value="${channelApi.channelCode!""}"
                               class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">出单账号</label>
                    <div class="layui-input-inline" style="float:left;width:400px;margin-right:10px;">
                        <select  name="userCode"  xm-select-max="1" xm-select = "select4" xm-select-search=""  style="width: 400px">
                            <#list userList?if_exists as user>
                                <option <#if channelApi.userCode?? && channelApi.userCode == user.userCode>selected</#if> value="${user.userCode!}">${user.userCode!}--${user.userName!}</option>
                            </#list>
                        </select>
                        <#--<input type="text" name="userCode" autocomplete="off" class="layui-input" value="${channelApi.userCode!""}">-->
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">接口代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="apiCode" autocomplete="off" class="layui-input" value="${channelApi.apiCode!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">限制数量</label>
                    <div class="layui-input-inline">
                        <input type="text" name="limits" autocomplete="off" class="layui-input" value="${channelApi.limits!""}">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">有效标志</label>
                    <div class="layui-input-block">
                        <input type="checkbox" checked value="<#if channelApi.validFlag??>${channelApi.validFlag?c}<#else>${channelApi.validFlag!"1"}</#if>" name="validFlag" lay-skin="switch" lay-text="有效|无效">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="channelApiAddOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(channelApiAddOrEditFormFilter)', function (data) {
            $.ajax({
                url: '${ctx}/channel/api/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        layer.close(index);
                        if(data.code == 0){
                            parent.layui.table.reload("channelApiTableId");

                            var iframeIndex = parent.layer.getFrameIndex(window.name);
                            parent.layer.close(iframeIndex);
                        }

                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });
    });
</script>
</body>
</html>
