<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
        .layui-form-label {
            width: 90px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <#if channelCode?? && channelCode.id?? >
                <input type="hidden" name="id" value="${channelCode.id?c}">
            </#if>
            <div class="layui-form-item">

                <div class="layui-inline">
                    <label class="layui-form-label">出单账号</label>
                    <div class="layui-input-inline" style="width: 400px">
                        <select  name="userCode"  xm-select-max="1" xm-select="selectCode" xm-select-search="" style="width: 400px">
                            <#list userList?if_exists as user>
                                <option <#if channelCode.userCode?? && channelCode.userCode == user.userCode>selected</#if> value="${user.userCode!}">${user.userCode!}--${user.userName!}</option>
                            </#list>
                        </select>
                        <#--<input type="text" name="userCode" autocomplete="off" class="layui-input" value="${channelCode.userCode!""}">-->
                    </div>
                </div>
                
                <div class="layui-inline">
                    <label class="layui-form-label">代码类型</label>
                    <div class="layui-input-inline">
                        <#--<input type="text" name="code" autocomplete="off" class="layui-input" value="${channelCode.code!""}">-->
                        <select name="code" lay-search="" >
                            <option value=""></option>
                            <#list apisSystemDataDictList?if_exists as apisSystemDataDict>
                                <option  data-configName="${apisSystemDataDict.dictName!""}"  <#if channelCode.code?? &&  channelCode.code ==  apisSystemDataDict.dictCode>selected</#if> value="${apisSystemDataDict.dictCode!}">${apisSystemDataDict.dictCode!}--${apisSystemDataDict.dictName!}</option>
                            </#list>
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">渠道值</label>
                    <div class="layui-input-inline">
                        <input type="text" name="channelValue" autocomplete="off" class="layui-input" value="${channelCode.channelValue!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">目标值</label>
                    <div class="layui-input-inline">
                        <input type="text" name="value" autocomplete="off" class="layui-input" value="${channelCode.value!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">接口URL</label>
                    <div class="layui-input-inline">
                        <input type="text" name="interfaceUrl" autocomplete="off" class="layui-input" value="${channelCode.interfaceUrl!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">渠道值描述</label>
                    <div class="layui-input-inline">
                        <input type="text" name="channelValueDesc" autocomplete="off" class="layui-input" value="${channelCode.channelValueDesc!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">目标值描述</label>
                    <div class="layui-input-inline">
                        <input type="text" name="valueDesc" autocomplete="off" class="layui-input" value="${channelCode.valueDesc!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">关联父类id</label>
                    <div class="layui-input-inline">
                        <input type="text" name="parentId" autocomplete="off" class="layui-input" value="${channelCode.parentId!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">值类别</label>
                    <div class="layui-input-inline">
                        <input type="text" name="valueClass" autocomplete="off" class="layui-input" value="${channelCode.valueClass!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">备注</label>
                    <div class="layui-input-inline">
                        <input type="text" name="remark" autocomplete="off" class="layui-input" value="${channelCode.remark!""}">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">有效标志</label>
                    <div class="layui-input-block">
                        <input type="checkbox" checked value="<#if channelCode.validFlag??>${channelCode.validFlag?c}<#else>${channelCode.validFlag!"1"}</#if>" name="validFlag" lay-skin="switch" lay-text="有效|无效">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="channelCodeAddOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(channelCodeAddOrEditFormFilter)', function (data) {
            $.ajax({
                url: '${ctx}/channel/code/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        layer.close(index);

                        if(data.code == 0){
                            parent.layui.table.reload("channelCodeTableId");

                            var iframeIndex = parent.layer.getFrameIndex(window.name);
                            parent.layer.close(iframeIndex);
                        }


                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });
    });
</script>
</body>
</html>
