<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">用户编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">代码类型</label>
                            <div class="layui-input-inline">
                                <#--<input type="text" name="code" autocomplete="off" class="layui-input">-->
                                <select name="code" lay-search=""  >
                                    <option value=""></option>
                                    <#list apisSystemDataDictList?if_exists as apisSystemDataDict>
                                        <option value="${apisSystemDataDict.dictCode!}">${apisSystemDataDict.dictCode!}--${apisSystemDataDict.dictName!}</option>
                                    </#list>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">渠道值</label>
                            <div class="layui-input-inline">
                                <input type="text" name="channelValue" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
<#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
            <#--<button class="layui-btn" href="javascript:;" data-iframe-tab="${ctx}/channel/code/add" data-title="添加主路由信息" data-icon="fa fa-plus-circle">添加</button>-->
<#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <script type="text/html" id="channelCodeIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelCode-page-Button-add")'>
                    <button id="channel-code-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","channelCode-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteAll"> 删除 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="channelCodeTableId" lay-filter="channelCodeTableFilter"></table>
        <script type="text/html" id="channelCodeTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/channel/code/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","channelCode-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","channelCode-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#channelCodeTableId',
            url: '${ctx}/channel/code/page',
            toolbar: '#channelCodeIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                {field: 'userCode',  title: '用户代码'},
                {field: 'code',  title: '代码类型'},
                {field: 'channelValue',  title: '渠道值'},
                {field: 'value',  title: '目标值'},
                // {field: 'interfaceUrl',title: '接口URL'},
                {field: 'channelValueDesc', title: '渠道值描述'},
                {field: 'valueDesc',  title: '目标值描述'},
                // {field: 'parentId',  title: '关联父类id'},
                // {field: 'valueClass',  title: '值类别'},
                // {field: 'remark', title: '备注'},
                {field: 'validFlag',  title: '有效标志',templet: function (d) {
                        return d.validFlag? '有效':'无效'
                    }},
                {title: '操作',  templet: '#channelCodeTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('channelCodeTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click","#channel-code-add-btn",function () {
            var index = layer.open({
                title: '添加代码',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/code/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })
        //
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(channelCodeTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑代码信息',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/code/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/code/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功');
                            table.reload("channelCodeTableId");
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });
        //头工具栏事件
        table.on('toolbar(channelCodeTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            if(obj.event === 'deleteAll'){
                var datas = checkStatus.data;
                var arrNew=new Array();
                var test2='';
                for(var i in datas){
                    console.log(datas[i].id);
                    arrNew.push(datas[i].id);
                    test2 = test2 + datas[i].id + ',';
                }
                console.log(test2);
                if(arrNew.length==0){
                    layer.alert("请选择一条数据");
                    return false;
                }
                layer.confirm('真的删除么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/code/deleteAll',
                        method: 'POST',
                        data: {"test2":test2},
                        success: function (data) {
                            layer.alert('删除成功');
                            table.reload("channelCodeTableId");
                        },
                        error: function (_data) {
                            layer.alert('删除失败' + JSON.stringify(_data))
                        }
                    })

                });
            }


        });

    });
</script>
</body>
</html>
