<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">产品代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="productCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                    </div>
                    <div class="layui-form-item">
                        <div class="layui-inline" style="width: 600px">
                            <label class="layui-form-label">配置编码</label>
                            <div class="layui-input-inline" style="width: 400px">
                                <select name="configCode" lay-search=""  >
                                    <option value=""></option>
                                    <#list apisSystemDataDictList?if_exists as apisSystemDataDict>
                                        <option value="${apisSystemDataDict.dictCode!}">${apisSystemDataDict.dictCode!}--${apisSystemDataDict.dictName!}</option>
                                    </#list>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                    <#--<div class="layui-form-item">-->
                       <#---->
                    <#--</div>-->

                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
        <#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
        <#--<button class="layui-btn" href="javascript:;" data-iframe-tab="${ctx}/channel/configs/add" data-title="添加主路由信息" data-icon="fa fa-plus-circle">添加</button>-->
        <#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <table class="layui-hide" id="channelConfigsTableId" lay-filter="channelConfigsTableFilter"></table>
        <script type="text/html" id="channelConfigsIndexToolbar">
            <div class="layui-btn-container">
                <button id="channel-configs-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加</button>
                <button class="layui-btn layui-btn-sm layui-btn-danger" lay-event="deleteall">删除</button>
            </div>
        </script>
        <script type="text/html" id="channelConfigsTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/channel/configs/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit"
               data-icon="fa fa-plus-circle">编辑</a>
            <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#channelConfigsTableId',
            url: '${ctx}/channel/configs/page',
            toolbar: '#channelConfigsIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                {field: 'userCode',  title: '出单账号'},
                {field: 'channelCode',  title: '渠道代码'},
                {field: 'productCode',  title: '产品代码'},
                {field: 'rationCode',  title: '商品代码'},
                {field: 'configCode',  title: '配置编码'},
                {field: 'configName',  title: '配置编码名称'},
                // {field: 'configValue',  title: '配置编码值'},
                // {field: 'valueType', title: '编码值类型'},
                // {field: 'remark',  title: '备注'},
                {title: '操作',  templet: '#channelConfigsTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('channelConfigsTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click", "#channel-configs-add-btn", function () {
            var index = layer.open({
                title: '添加渠道配置',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/configs/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(channelConfigsTableFilter)', function (obj) {
            var data = obj.data;
            console.log(data + "原始数据" + data.toString());
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑配置信息',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/configs/edit?id=' + data.id,
                });
                console.log(data + "编辑数据" + data);
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/configs/delete?id=' + data.id,
                        method: 'POST',
                        success: function (_data) {
                            layer.close(index);
                            layer.alert('删除成功');
                            table.reload("channelConfigsTableId");
                        },
                        error: function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })
                });
            }
        });
        //头工具栏事件
        table.on('toolbar(channelConfigsTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            switch (obj.event) {
                case 'deleteall':
                    var datas = checkStatus.data;
                    let arrNew=new Array();
                    var test2='';
                    for(var i in datas){
                        console.log(datas[i].id);
                        arrNew.push(datas[i].id);
                        test2 = test2 + datas[i].id + ',';
                    }
                    if(arrNew.length==0){
                        layer.alert("请选择一条数据");
                        return false;
                    }
                    layer.confirm('真的删除行么', function (index) {
                        $.ajax({
                            url: '${ctx}/channel/configs/deleteAll',
                            method: 'POST',
                            data: {"test2":test2},
                            success: function (_data) {
                                layer.close(index);
                                layer.alert('删除成功');
                                table.reload("channelConfigsTableId");
                            },
                            error: function (_data) {
                                layer.alert('删除失败' + JSON.stringify(_data))
                            }
                        })

                    });
                    break;
            };
        });

    });
</script>
</body>
</html>
