<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
        .layui-form-label {
            width: 90px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <#if channelProduct?? && channelProduct.id?? >
                <input type="hidden" name="id" value="${channelProduct.id?c}">
            </#if>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">外部渠道代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="channelCode" placeholder="请输入" autocomplete="off"  value="${channelProduct.channelCode!""}"
                               class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">出单账号</label>
                    <div class="layui-input-inline" style="float:left;width:400px;margin-right:10px;">
                        <select  name="userCode" xm-select-max="1" xm-select = "select3" xm-select-search=""  style="width: 400px">
                            <#list userList?if_exists as user>
                                <option <#if channelProduct.userCode?? && channelProduct.userCode == user.userCode>selected</#if> value="${user.userCode!}">${user.userCode!}--${user.userName!}</option>
                            </#list>
                        </select>
                        <#--<input type="text" name="userCode" autocomplete="off" class="layui-input" value="${channelProduct.userCode!""}">-->
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">产品代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="productCode" autocomplete="off" class="layui-input" value="${channelProduct.productCode!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">计划代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="planCode" autocomplete="off" class="layui-input" value="${channelProduct.planCode!""}">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">有效标志</label>
                    <div class="layui-input-inline">
                        <input type="checkbox" checked value="<#if channelProduct.validFlag??>${channelProduct.validFlag?c}<#else>${channelProduct.validFlag!"1"}</#if>" name="validFlag" lay-skin="switch" lay-text="有效|无效">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="channelProductAddOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(channelProductAddOrEditFormFilter)', function (data) {
            $.ajax({
                url: '${ctx}/channel/product/doEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        layer.close(index);

                        if(data.code == 0){
                            parent.layui.table.reload("channelProductTableId");

                            var iframeIndex = parent.layer.getFrameIndex(window.name);
                            parent.layer.close(iframeIndex);
                        }

                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });
    });
</script>
</body>
</html>
