<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        
                        <div class="layui-inline">
                            <label class="layui-form-label">渠道编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="channelCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">产品代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="productCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">计划代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="planCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <div class="layui-input-inline">
                                <input type="checkbox" checked value="false" name="validFlag" lay-skin="switch" lay-filter="switchTest" lay-text="有效|无效">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
<#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
            <#--<button class="layui-btn" href="javascript:;" data-iframe-tab="${ctx}/channel/product/add" data-title="添加主路由信息" data-icon="fa fa-plus-circle">添加</button>-->
<#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <script type="text/html" id="channelProductIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelProduct-page-Button-add")'>
                    <button id="channel-product-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","channelProduct-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteall"> 删除 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="channelProductTableId" lay-filter="channelProductTableFilter"></table>
        <script type="text/html" id="channelProductTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/channel/product/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","channelProduct-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","channelProduct-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#channelProductTableId',
            url: '${ctx}/channel/product/page',
            toolbar: '#channelProductIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                // {field: 'id', width: 80, title: 'ID', sort: true},
                {field: 'channelCode',  title: '渠道代码'},
                {field: 'userCode',  title: '出单账号'},
                {field: 'productCode', title: '产品代码'},
                {field: 'planCode',  title: '计划代码'},
                {field: 'validFlag',  title: '有效标志',templet: function (d) {
                        return d.validFlag? '有效':'无效'
                    }},
                {title: '操作',  templet: '#channelProductTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('channelProductTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click","#channel-product-add-btn",function () {
            var index = layer.open({
                title: '添加产品',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/product/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })
        //
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(channelProductTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑产品信息',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/product/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/product/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });

        table.on('toolbar(channelProductTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            switch (obj.event) {
                case 'deleteall':
                    var datas = checkStatus.data;
                    let arrNew=new Array();
                    var test2='';
                    for(var i in datas){
                        console.log(datas[i].id);
                        arrNew.push(datas[i].id);
                        test2 = test2 + datas[i].id + ',';
                    }
                    if(arrNew.length==0){
                        layer.alert("请选择一条数据");
                        return false;
                    }
                    layer.confirm('真的删除行么', function (index) {
                        $.ajax({
                            url: '${ctx}/channel/product/deleteAll',
                            method: 'POST',
                            data: {"test2":test2},
                            success: function (_data) {
                                layer.close(index);
                                layer.alert('删除成功');
                                table.reload("channelProductTableId");
                            },
                            error: function (_data) {
                                layer.alert('删除失败' + JSON.stringify(_data))
                            }
                        })

                    });
                    break;
            };
        });

    });
</script>
</body>
</html>
