<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="" id="userSerchForm">
                    <div class="layui-form-item">
                        <#--<div class="layui-inline">-->
                            <#--<label class="layui-form-label">渠道类型</label>-->
                            <#--<div class="layui-input-inline">-->
                                <#--<input type="text" name="channelType" autocomplete="off" class="layui-input">-->
                            <#--</div>-->
                        <#--</div>-->
                        <div class="layui-inline">
                            <label class="layui-form-label">渠道编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="channelCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">渠道名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="channelName" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号名</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userName" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">创建时间</label>
                            <div class="layui-input-inline">
                                <input type="text" name="startDate"  id="startDate" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <script type="text/html" id="channelUserIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelUser-page-Button-add")'>
                    <button id="channel-user-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","channelUser-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteAll"> 删除 </button>
                </@security.authorize>
                <button  class="layui-btn layui-btn-sm data-add-btn" lay-event="export"> 导出 </button>
            </div>
        </script>
        <table class="layui-hide" id="channelUserTableId" lay-filter="channelUserTableFilter"></table>
        <script type="text/html" id="channelUserTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/channel/user/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","channelUser-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","channelUser-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table', 'laydate'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table,
            laydate = layui.laydate;

        laydate.render({
            elem: '#startDate',
            type: 'datetime',
            format: 'yyyyMMddHHmmss',
            range: true
        });
        laydate.render({
            elem: '#endDate',
            type: 'datetime'
        });


        table.render({
            elem: '#channelUserTableId',
            url: '${ctx}/channel/user/page',
            toolbar: '#channelUserIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                {field: 'channelType',  title: '渠道类型'},
                {field: 'channelCode',  title: '渠道编码'},
                {field: 'channelName',  title: '渠道名称'},
                {field: 'userCode',  title: '出单账号'},
                {field: 'userName',  title: '出单账号名'},
                {field: 'makeCom',  title: '出单机构'},
                {field: 'comCode',  title: '归属机构'},
                {field: 'handlerCode',  title: '归属业务员'},
                {field: 'createTime',  title: '创建时间'},
                {title: '操作',  templet: '#channelUserTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('channelUserTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click","#channel-user-add-btn",function () {
            var index = layer.open({
                title: '添加用户',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/user/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        });
        // 监听添加操作
        <#--$(document).on("click","#export",function () {-->
           <#--location.href="${ctx}/channel/user/downLoad"-->
        <#--});-->
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(channelUserTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑用户信息',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/user/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/user/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });
        table.on('toolbar(channelUserTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            switch (obj.event) {
                case 'deleteAll':
                    var datas = checkStatus.data;
                    let arrNew=new Array();
                    var test2='';
                    for(var i in datas){
                        console.log(datas[i].id);
                        arrNew.push(datas[i].id);
                        test2 = test2 + datas[i].id + ',';
                    }
                    if(arrNew.length==0){
                        layer.alert("请选择一条数据");
                        return false;
                    }
                    layer.confirm('真的删除么', function (index) {
                        $.ajax({
                            url: '${ctx}/channel/user/deleteAll',
                            method: 'POST',
                            data: {"test2":test2},
                            success: function (_data) {
                                layer.alert('删除成功');
                                location.reload();
                            },
                            error: function (_data) {
                                layer.alert('删除失败' + JSON.stringify(_data))
                            }
                        })

                    });
                    break;
                case "export":
                    var params = $("#userSerchForm").serialize();
                    $.ajax({
                        url: '${ctx}/channel/user/countUser',
                        method: 'POST',
                        data: $("#userSerchForm").serialize(),
                        success: function (data) {
                            if(data.code==0){
                                layer.alert('没有可以导出的数据');
                            }else{
                                location.href="${ctx}/channel/user/downLoad?"+params;
                            }
                        },
                        error: function (_data) {
                        }
                    })
            };
        });

    });
</script>
</body>
</html>
