<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }

        .layui-form-label {
            width: 90px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="${ctx}/channel/configs/doAddOrEdit">
            <#if warnConfigs?? && warnConfigs.id?? >
                <input type="hidden" name="id" value="${warnConfigs.id?c}">
            </#if>

            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">规则名称</label>
                    <div class="layui-input-inline">
                        <input type="text" name="ruleName" class="layui-input"
                               value="${warnConfigs.ruleName!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">规则代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="ruleCode" class="layui-input"
                               value="${warnConfigs.ruleCode!""}">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">收件人(;隔开)</label>
                    <div class="layui-input-inline">
                        <input type="text" name="emailToList" class="layui-input"
                               value="${warnConfigs.emailToList!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">抄送人(;隔开)</label>
                    <div class="layui-input-inline">
                        <input type="text" name="emailCcList" class="layui-input"
                               value="${warnConfigs.emailCcList!""}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-row">
                    <label class="layui-form-label">出单账号</label>
                    <div class="layui-col-md6">
                        <input type="hidden" value="${warnConfigs.userCodeList!""}" id="userCodes">
                        <select id="userCodeList" name="userCodeList" xm-select="selectUserCode" xm-select-search="">
                            <#list userList?if_exists as user>
                            <option <#if warnConfigs.userCode?? && warnConfigs.userCode  == user.value>selected</#if>
                            value="${user.userCode!""}">${user.userName!""}(${user.userCode!""})</option>
                            </#list>
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-row">
                    <label class="layui-form-label">产品代码</label>
                    <div class="layui-col-md6">
                        <input type="hidden" value="${warnConfigs.productCodeList!""}" id="sproductCodes">
                        <select id="productCodeList" name="productCodeList" xm-select="selectProductCode" xm-select-search="">
                            <#list productList?if_exists as product>
                            <option <#if warnConfigs.productCode?? && warnConfigs.productCode  == product.value>selected</#if>
                        value="${product.value!""}">${product.valueDesc!""}(${product.value!""})</option>
                            </#list>
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-row">
                    <label class="layui-form-label">邮件主题模板</label>
                    <div class="layui-col-md6">
                        <textarea name="emailSubjectTpl" placeholder="请输入内容" class="layui-textarea">${warnConfigs.emailSubjectTpl!""}</textarea>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-row">
                    <label class="layui-form-label">邮件内容模板</label>
                    <div class="layui-col-md6">
                        <textarea name="emailContentTpl" placeholder="请输入内容" class="layui-textarea">${warnConfigs.emailContentTpl!""}</textarea>
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">备注</label>
                    <div class="layui-input-inline">
                        <input type="text" name="remark" autocomplete="off" class="layui-input"
                               value="${warnConfigs.remark!""}">
                    </div>
                </div>
            </div>

            <#if warnConfigs?? && warnConfigs.id?? >
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <label class="layui-form-label">创建人</label>
                        <div class="layui-input-inline">
                            <input type="text" name="creator" readonly  autocomplete="off" class="layui-input" value="${warnConfigs.creator!""}">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label">创建时间</label>
                        <div class="layui-input-inline">
                            <#if warnConfigs.createTime??>
                                <input type="text" name="createTime" readonly   autocomplete="off" class="layui-input" value="${warnConfigs.createTime? string('yyyy-MM-dd HH:mm:ss')}">
                            <#else >
                                <input type="text" name="createTime" readonly  class="layui-input" value="">
                            </#if>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <label class="layui-form-label">修改人</label>
                        <div class="layui-input-inline">
                            <input type="text" name="modifier" readonly  autocomplete="off" class="layui-input" value="${warnConfigs.modifier!""}">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label">修改时间</label>
                        <div class="layui-input-inline">
                            <#if warnConfigs.updateTime??>
                                <input type="text" name="updateTime" readonly   autocomplete="off" class="layui-input" value="${warnConfigs.updateTime? string('yyyy-MM-dd HH:mm:ss')}">
                            <#else >
                                <input type="text" name="updateTime"  readonly class="layui-input" value="">
                            </#if>
                        </div>
                    </div>
                </div>
            </#if>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="warnConfigsAddOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        var formSelects = layui.formSelects;
        // 出单账号select
        var userArr = $("#userCodes").val().split(",");
        formSelects.value('selectUserCode', userArr);
        // 产品代码select
        var productArr = $("#sproductCodes").val().split(",");
        formSelects.value('selectProductCode', productArr);

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(warnConfigsAddOrEditFormFilter)', function (data) {
            $.ajax({
                url: '${ctx}/channel/warn/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();
                        layer.close(index);
                        if(data.code == 0){
                            parent.layui.table.reload("channelWarnConfigsTableId");
                            var iframeIndex = parent.layer.getFrameIndex(window.name);
                            parent.layer.close(iframeIndex);
                        }
                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });

    });
</script>
</body>
</html>
