<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
             <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">产品代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="productCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <table class="layui-hide" id="channelWarnConfigsTableId" lay-filter="channelWarnConfigsTableFilter"></table>
        <script type="text/html" id="channelWarnConfigsIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelWarnConfig-page-Button-add")'>
                    <button id="warn-configs-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加</button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","channelWarnConfig-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger" lay-event="deleteall">删除</button>
                </@security.authorize>
            </div>
        </script>
        <script type="text/html" id="channelWarnConfigsTableBar">
            <@security.authorize access='hasAnyAuthority("admin","channelWarnConfig-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit"
                data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","channelWarnConfig-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#channelWarnConfigsTableId',
            url: '${ctx}/channel/warn/page',
            toolbar: '#channelWarnConfigsIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                {field: 'ruleName',  title: '规则名称'},
                {field: 'emailToList',  title: '收件人'},
                {field: 'emailCcList',  title: '抄送人'},
                {field: 'productCodeList',  title: '产品代码'},
                {field: 'userCodeList',  title: '出单账号'},
                {field: 'ruleCode', title: '规则代码'},
                {field: 'emailSubjectTpl',  title: '邮件主题模板'},
                {field: 'emailContentTpl',  title: '邮件内容模板'},
                // {field: 'remark',  title: '备注'},
                {title: '操作',  templet: '#channelWarnConfigsTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);

            //执行搜索重载
            table.reload('channelWarnConfigsTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click", "#warn-configs-add-btn", function () {
            var index = layer.open({
                title: '添加告警信息配置',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/warn/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })

        table.on('tool(channelWarnConfigsTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑告警配置信息',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/warn/edit?id=' + data.id,
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/warn/delete?id=' + data.id,
                        method: 'POST',
                        success: function (_data) {
                            layer.close(index);
                            layer.alert('删除成功');
                            table.reload("channelWarnConfigsTableId");
                        },
                        error: function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })
                });
            }
        });
        //头工具栏事件
        table.on('toolbar(channelWarnConfigsTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            switch (obj.event) {
                case 'deleteall':
                    var datas = checkStatus.data;
                    let arrNew=new Array();
                    var ids='';
                    for(var i in datas){
                        console.log(datas[i].id);
                        arrNew.push(datas[i].id);
                        ids = ids + datas[i].id + ',';
                    }
                    if(arrNew.length==0){
                        layer.alert("请选择一条数据");
                        return false;
                    }
                    layer.confirm('真的删除行么', function (index) {
                        $.ajax({
                            url: '${ctx}/channel/warn/deleteAll',
                            method: 'POST',
                            data: {"ids":ids},
                            success: function (_data) {
                                layer.close(index);
                                layer.alert('删除成功');
                                table.reload("channelWarnConfigsTableId");
                            },
                            error: function (_data) {
                                layer.alert('删除失败' + JSON.stringify(_data))
                            }
                        })

                    });
                    break;
            };
        });

    });
</script>
</body>
</html>
