<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        
                        <div class="layui-inline">
                            <label class="layui-form-label">名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="name" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        
                        <div class="layui-inline">
                            <label class="layui-form-label">内容</label>
                            <div class="layui-input-inline">
                                <input type="text" name="context" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <div class="layui-input-inline">
                                <input type="checkbox" checked value="true" name="validFlag" lay-skin="switch" lay-filter="switchTest" lay-text="有效|无效">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <script type="text/html" id="ediActionIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","ediAction-page-Button-add")'>
                    <button id="edi-action-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","ediAction-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn"> 删除 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="ediActionTableId" lay-filter="ediActionTableFilter"></table>
        <script type="text/html" id="ediActionTableBar">
            <!--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/edi/action/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","ediAction-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","ediAction-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#ediActionTableId',
            url: '${ctx}/edi/action/page',
            toolbar: '#ediActionIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox", width: 50, fixed: "left"},
                {field: 'id', width: 80, title: 'ID', sort: true},
                {field: 'name', width: 100, title: '名称'},
                {field: 'context', width: 100, title: '内容'},
                {field: 'limits', width: 100, title: '限制数量'},
                {field: 'validFlag', width: 100, title: '有效标志',templet: function (d) {
                        return d.validFlag? '有效':'无效'
                    }},
                {title: '操作', minWidth: 50, templet: '#ediActionTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('ediActionTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click","#edi-action-add-btn",function () {
            var index = layer.open({
                title: '添加处理器配置',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/edi/action/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })
        //
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(ediActionTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑处理器配置',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/edi/action/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/edi/action/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });

    });
</script>
</body>
</html>
