<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
             margin: 10px;
         }
        .layui-form-label {
            width: 90px;
        }
        .textarea-inherit {
            width: 100%;
            height: 400px;
            overflow: auto;
            word-break: break-all; //解决兼容问题
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <div class="layui-form-item">
                <label>请求内容:</label>
                <textarea id="body_input" class="textarea-inherit">${requestBody!""}</textarea>

                <button type="button" id="formatting" class="layui-btn layui-btn-primary layui-btn-margin" onclick="dojson()"> 格式化</button>

            </div>


        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>


    var callbackdata = function (obj) {
        var data = $("#body_input").val();
        console.log("子页面的报文值：" + data);
        return data;
    }


    function dojson() {
        var text = $("#body_input").val();
        console.log("进入dojson：" + text);
        text = formatJson(text);
        $("#body_input").val(text);
    }



    //格式化代码函数,已经用原生方式写好了不需要改动,直接引用就好
    var formatJson = function (json, options) {
        var reg = null,
                formatted = '',
                pad = 0,
                PADDING = ' ';
        options = options || {};
        options.newlineAfterColonIfBeforeBraceOrBracket = (options.newlineAfterColonIfBeforeBraceOrBracket === true) ? true : false;
        options.spaceAfterColon = (options.spaceAfterColon === false) ? false : true;
        if (typeof json !== 'string') {
            json = JSON.stringify(json);
        } else {
            json = JSON.parse(json);
            json = JSON.stringify(json);
        }
        reg = /([\{\}])/g;
        json = json.replace(reg, '\r\n$1\r\n');
        reg = /([\[\]])/g;
        json = json.replace(reg, '\r\n$1\r\n');
        reg = /(\,)/g;
        json = json.replace(reg, '$1\r\n');
        reg = /(\r\n\r\n)/g;
        json = json.replace(reg, '\r\n');
        reg = /\r\n\,/g;
        json = json.replace(reg, ',');
        if (!options.newlineAfterColonIfBeforeBraceOrBracket) {
            reg = /\:\r\n\{/g;
            json = json.replace(reg, ':{');
            reg = /\:\r\n\[/g;
            json = json.replace(reg, ':[');
        }
        if (options.spaceAfterColon) {
            reg = /\:/g;
            json = json.replace(reg, ':');
        }
        (json.split('\r\n')).forEach(function (node, index) {
                    var i = 0,
                            indent = 0,
                            padding = '';
                    if (node.match(/\{$/) || node.match(/\[$/)) {
                        indent = 1;
                    } else if (node.match(/\}/) || node.match(/\]/)) {
                        if (pad !== 0) {
                            pad -= 1;
                        }
                    } else {
                        indent = 0;
                    }
                    for (i = 0; i < pad; i++) {
                        padding += PADDING;
                    }
                    formatted += padding + node + '\r\n';
                    pad += indent;
                }
        );
        return formatted;
    }

    /*layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        $("#body_input").val("2");
        window.onLoad=function(){
            $("#body_input").val("1");

        }
    });*/
</script>
</body>
</html>
